/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedUpgradesRecipeCategory
implements IRecipeCategory<SpeedUpgradesRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"speed_upgrades");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_dynamic.png");
    public static final RecipeType<SpeedUpgradesRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"speed_upgrades", SpeedUpgradesRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;
    private final Map<Point, SpeedUpgradesRecipe> slotRecipes = new HashMap<Point, SpeedUpgradesRecipe>();
    private int backgroundWidth;

    public SpeedUpgradesRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 114);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR.get()));
    }

    public RecipeType<SpeedUpgradesRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.SPEED_UPGRADES;
    }

    public boolean isHandled(SpeedUpgradesRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Speed Blocks");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(SpeedUpgradesRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SpeedUpgradesRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((SpeedUpgradesRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpeedUpgradesRecipe recipe, IFocusGroup focusGroup) {
        ++this.tabs_used;
        List<SpeedUpgradesRecipe> recipes = new ArrayList(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SpeedUpgradesRecipe.Type.INSTANCE)).stream().map(RecipeHolder::value).toList();
        ArrayList<SpeedUpgradesRecipe> mutableRecipes = new ArrayList<SpeedUpgradesRecipe>(recipes);
        mutableRecipes.sort(Comparator.comparingInt(SpeedUpgradesRecipe::tickRate));
        int yOffset = 20;
        int numRows = (int)Math.ceil((double)mutableRecipes.size() / 9.0);
        int numCols = Math.min(9, mutableRecipes.size());
        this.backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19 + yOffset;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, this.backgroundWidth, backgroundHeight);
        this.slotRecipes.clear();
        for (int i = 0; i < mutableRecipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = yOffset + 2 + i / 9 * 19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addIngredients(((SpeedUpgradesRecipe)mutableRecipes.get(i)).input())).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, slotX - i % 9 * 19 - 5, slotY - (2 + i / 9 * 19) - 1 - 20);
            builder.addSlot(RecipeIngredientRole.OUTPUT, slotX, slotY).addIngredients(((SpeedUpgradesRecipe)mutableRecipes.get(i)).input());
            this.slotRecipes.put(new Point(slotX, slotY), (SpeedUpgradesRecipe)mutableRecipes.get(i));
        }
    }

    public void draw(SpeedUpgradesRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        String durationText = null;
        for (Map.Entry<Point, SpeedUpgradesRecipe> entry : this.slotRecipes.entrySet()) {
            Point position = entry.getKey();
            SpeedUpgradesRecipe hoveredRecipe = entry.getValue();
            int slotX = position.x;
            int slotY = position.y;
            int slotWidth = 18;
            int slotHeight = 18;
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + slotWidth)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + slotHeight))) continue;
            int duration = hoveredRecipe.tickRate();
            durationText = "Duration: " + duration / 20 + "s / " + duration + " ticks";
            break;
        }
        if (durationText != null) {
            int screenWidth = this.backgroundWidth;
            int textWidth = Minecraft.getInstance().font.width(durationText);
            int textX = (screenWidth - textWidth) / 2;
            int textY = 4;
            guiGraphics.drawString(Minecraft.getInstance().font, durationText, textX, textY, -1, true);
        }
    }
}

