/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.SummoningBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.config.ConfigFile;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.recipe.SummoningBlockRecipe;
import com.benbenlaw.opolisutilities.screen.custom.SummoningBlockMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            SummoningBlockEntity.this.setChanged();
            SummoningBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return 1;
            }
            if (slot == 2) {
                return 1;
            }
            return stack.getMaxStackSize();
        }
    };
    public final ContainerData data;
    public int validCheck = 0;
    public int progress = 0;
    public int maxProgress = 220;
    public String mob = "";
    public static final int INPUT_SLOT = 1;
    public static final int CATALYST = 0;
    public static final int UPGRADE_SLOT = 2;
    private final IItemHandler summoningBlockItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> false);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        return this.summoningBlockItemHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public SummoningBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SUMMONING_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> SummoningBlockEntity.this.progress;
                    case 1 -> SummoningBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        SummoningBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        SummoningBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.summoning_block");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new SummoningBlockMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putInt("validCheck", this.validCheck);
        compoundTag.putString("mob", this.mob);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.validCheck = compoundTag.getInt("validCheck");
        this.mob = compoundTag.getString("mob");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.sync();
            for (RecipeHolder match : this.level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
                NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match.value()).getIngredients();
                block1: for (Object ingredient : input) {
                    for (ItemStack itemStack : ingredient.getItems()) {
                        if (!this.itemHandler.getStackInSlot(2).is(itemStack.getItem())) continue;
                        this.maxProgress = ((SpeedUpgradesRecipe)match.value()).tickRate();
                        continue block1;
                    }
                }
            }
            if (this.itemHandler.getStackInSlot(2).isEmpty()) {
                this.maxProgress = 220;
            }
            if (((Boolean)this.getBlockState().getValue((Property)SummoningBlock.POWERED)).booleanValue()) {
                if (((Boolean)ConfigFile.summoningBlockCheckForSameEntityBeforeSpawningNewEntity.get()).booleanValue()) {
                    int range = (Integer)ConfigFile.summoningBlockRangeCheck.get();
                    AABB boundingBox = new AABB(this.getBlockPos().offset(-range, -range, -range).getCenter(), this.getBlockPos().offset(2, 2, 2).getCenter());
                    List nearbyEntities = this.level.getEntitiesOfClass(Entity.class, boundingBox, entity -> entity.getType().equals(Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.mob)))));
                    if (!nearbyEntities.isEmpty()) {
                        return;
                    }
                }
                RecipeInput inventory = new RecipeInput(){

                    @NotNull
                    public ItemStack getItem(int index) {
                        return SummoningBlockEntity.this.itemHandler.getStackInSlot(index);
                    }

                    public int size() {
                        return SummoningBlockEntity.this.itemHandler.getSlots();
                    }
                };
                for (Object match : this.level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
                    NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match.value()).getIngredients();
                    block4: for (Ingredient ingredient : input) {
                        for (ItemStack itemStack : ingredient.getItems()) {
                            if (!this.itemHandler.getStackInSlot(2).is(itemStack.getItem())) continue;
                            this.maxProgress = ((SpeedUpgradesRecipe)match.value()).tickRate();
                            continue block4;
                        }
                    }
                }
                if (this.itemHandler.getStackInSlot(2).isEmpty()) {
                    this.maxProgress = 220;
                }
                this.sync();
                Optional<Object> selectedRecipe = Optional.empty();
                for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)SummoningBlockRecipe.Type.INSTANCE, inventory, this.level)) {
                    SummoningBlockRecipe recipe = (SummoningBlockRecipe)recipeHolder.value();
                    if (!this.hasInput(this, recipe) || !this.hasCatalyst(this, recipe)) continue;
                    selectedRecipe = Optional.of(recipeHolder);
                    break;
                }
                if (selectedRecipe.isPresent()) {
                    Object match;
                    match = (RecipeHolder)selectedRecipe.get();
                    ++this.progress;
                    this.mob = ((SummoningBlockRecipe)match.value()).mob();
                    if (this.progress >= this.maxProgress) {
                        this.progress = 0;
                        EntityType entity2 = Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.mob)));
                        Entity mobAsEntity = entity2.create(this.level);
                        assert (mobAsEntity != null);
                        mobAsEntity.setPos((double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5);
                        mobAsEntity.setYRot(this.getRotation());
                        mobAsEntity.setYHeadRot(this.getRotation());
                        this.level.addFreshEntity(mobAsEntity);
                        this.itemHandler.getStackInSlot(1).shrink(((SummoningBlockRecipe)match.value()).input().count());
                        this.mob = "";
                    }
                } else {
                    this.resetProgress();
                }
            }
        }
    }

    public Entity getEntity() {
        if (this.mob.isEmpty()) {
            return null;
        }
        assert (this.level != null);
        return Objects.requireNonNull((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.mob))).create(this.level);
    }

    public float getRotation() {
        Direction direction = (Direction)this.getBlockState().getValue((Property)SummoningBlock.FACING);
        float yaw = 0.0f;
        switch (direction) {
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
        }
        return yaw;
    }

    public float getScaledProgress() {
        float entitySize = 1.0f;
        return this.maxProgress != 0 && this.progress != 0 ? (float)this.progress * entitySize / (float)this.maxProgress : 0.0f;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasInput(SummoningBlockEntity entity, SummoningBlockRecipe recipe) {
        if (recipe.input().test(entity.itemHandler.getStackInSlot(1)) && recipe.catalyst().test(entity.itemHandler.getStackInSlot(0))) {
            return recipe.input().count() <= entity.itemHandler.getStackInSlot(1).getCount();
        }
        return false;
    }

    private boolean hasCatalyst(SummoningBlockEntity entity, SummoningBlockRecipe recipe) {
        return recipe.catalyst().test(entity.itemHandler.getStackInSlot(0));
    }
}

