/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.FluidGeneratorBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.screen.custom.FluidGeneratorMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            FluidGeneratorBlockEntity.this.setChanged();
            FluidGeneratorBlockEntity.this.sync();
        }
    };
    public final FluidTank FLUID_TANK = new FluidTank(64000){

        protected void onContentsChanged() {
            FluidGeneratorBlockEntity.this.setChanged();
            FluidGeneratorBlockEntity.this.sync();
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    public int fluidAmount;
    public String resource = "";
    private final IItemHandler outputItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> i == 1);
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidGeneratorBlockEntity.this.FLUID_TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return FluidGeneratorBlockEntity.this.FLUID_TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return FluidGeneratorBlockEntity.this.FLUID_TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == FluidGeneratorBlockEntity.this.FLUID_TANK.getFluid().getFluid()) {
                return FluidGeneratorBlockEntity.this.FLUID_TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (FluidGeneratorBlockEntity.this.FLUID_TANK.getFluidAmount() > 0) {
                return FluidGeneratorBlockEntity.this.FLUID_TANK.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };

    public IItemHandler getItemHandlerCapability(Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.outputItemHandler;
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public FluidGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FLUID_GENERATOR_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> FluidGeneratorBlockEntity.this.progress;
                    case 1 -> FluidGeneratorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidGeneratorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FluidGeneratorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.fluid_generator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new FluidGeneratorMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.FLUID_TANK);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putString("resource", this.resource);
        compoundTag.putInt("fluidAmount", this.fluidAmount);
        compoundTag.put("fluidTank", (Tag)this.FLUID_TANK.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.resource = compoundTag.getString("resource");
        this.fluidAmount = compoundTag.getInt("fluidAmount");
        this.FLUID_TANK.readFromNBT(provider, compoundTag.getCompound("fluidTank"));
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        Level level = this.level;
        BlockPos blockPos = this.worldPosition;
        assert (level != null);
        if (!level.isClientSide()) {
            this.sync();
            for (Object match : level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match.value()).getIngredients();
                block1: for (Ingredient ingredient : input) {
                    for (ItemStack itemStack : ingredient.getItems()) {
                        if (!this.itemHandler.getStackInSlot(1).is(itemStack.getItem())) continue;
                        this.maxProgress = ((SpeedUpgradesRecipe)match.value()).tickRate();
                        continue block1;
                    }
                }
            }
            if (this.itemHandler.getStackInSlot(1).isEmpty()) {
                this.maxProgress = 220;
            }
            boolean isMatchingFluid = false;
            for (RecipeHolder genBlocks : level.getRecipeManager().getRecipesFor((RecipeType)FluidGeneratorRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                Fluid recipeFluid = ((FluidGeneratorRecipe)genBlocks.value()).input().getFluid();
                ItemStack bucketStack = this.itemHandler.getStackInSlot(0);
                FluidStack bucketFluidStack = FluidUtil.getFluidContained((ItemStack)bucketStack).orElse(FluidStack.EMPTY);
                if (bucketFluidStack.isEmpty() || bucketFluidStack.getFluid() != recipeFluid) continue;
                isMatchingFluid = true;
                this.resource = recipeFluid.getFluidType().toString();
                this.fluidAmount = ((FluidGeneratorRecipe)genBlocks.value()).input().getAmount();
                level.setBlockAndUpdate(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)FluidGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                break;
            }
            if (!isMatchingFluid) {
                this.resource = "";
                level.setBlockAndUpdate(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)FluidGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
            if (this.itemHandler.getStackInSlot(0).isEmpty()) {
                this.progress = 0;
            } else if (this.FLUID_TANK.getFluidAmount() < this.FLUID_TANK.getCapacity()) {
                FluidStack currentFluidInTank = this.FLUID_TANK.getFluid();
                Fluid fluidStack = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)this.resource));
                if ((currentFluidInTank.isEmpty() || currentFluidInTank.getFluid() == fluidStack) && isMatchingFluid) {
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        this.progress = 0;
                        if (level.getBlockState(blockPos).is((Block)ModBlocks.FLUID_GENERATOR.get())) {
                            this.FLUID_TANK.fill(new FluidStack(fluidStack, this.fluidAmount), IFluidHandler.FluidAction.EXECUTE);
                            this.setChanged();
                        }
                    }
                }
            }
        }
    }
}

