/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.client;

import com.benbenlaw.opolisutilities.block.custom.SummoningBlock;
import com.benbenlaw.opolisutilities.block.entity.custom.SummoningBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class SummoningBlockEntityRenderer
implements BlockEntityRenderer<SummoningBlockEntity> {
    private final EntityRenderDispatcher entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher();

    public SummoningBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SummoningBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 1.0f, 0.5f);
        float scaledProgress = pBlockEntity.getScaledProgress();
        pPoseStack.scale(scaledProgress, scaledProgress, scaledProgress);
        pPoseStack.translate(0.0f, -0.5f * (1.0f - scaledProgress), 0.0f);
        Direction direction = (Direction)pBlockEntity.getBlockState().getValue((Property)SummoningBlock.FACING);
        float yaw = 0.0f;
        switch (direction) {
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case EAST: {
                yaw = 90.0f;
                break;
            }
            case WEST: {
                yaw = -90.0f;
                break;
            }
        }
        pPoseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        Entity entity = pBlockEntity.getEntity();
        if (entity != null) {
            this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, pPoseStack, pBufferSource, pPackedLight);
        }
        pPoseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

