/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.custom;

import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.ItemRepairerBlockEntity;
import com.benbenlaw.opolisutilities.screen.custom.ItemRepairerMenu;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRepairerBlock
extends BaseEntityBlock {
    public static final MapCodec<ItemRepairerBlock> CODEC = ItemRepairerBlock.simpleCodec(ItemRepairerBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public ItemRepairerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public BlockState rotate(BlockState blockState, @NotNull LevelAccessor level, @NotNull BlockPos blockPos, Rotation direction) {
        return (BlockState)((BlockState)blockState.setValue((Property)FACING, (Comparable)direction.rotate((Direction)blockState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)blockState.getValue((Property)POWERED)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        BlockEntity blockEntity;
        if (blockState.getBlock() != newBlockState.getBlock() && (blockEntity = level.getBlockEntity(blockPos)) instanceof ItemRepairerBlockEntity) {
            ((ItemRepairerBlockEntity)blockEntity).drops();
        }
        super.onRemove(blockState, level, blockPos, newBlockState, isMoving);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            ItemRepairerBlockEntity itemRepairerBlockEntity = (ItemRepairerBlockEntity)level.getBlockEntity(blockPos);
            if (itemRepairerBlockEntity instanceof ItemRepairerBlockEntity) {
                ContainerData data = itemRepairerBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ItemRepairerMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.opolisutilities.item_repairer")), buf -> buf.writeBlockPos(blockPos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ItemRepairerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return ItemRepairerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ITEM_REPAIRER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

