/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.notification;

import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.NotificationScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class YouSureScreen
extends NotificationScreen {
    private static final Component CONFIRM = ComponentBuilder.button("confirm", new Object[0]);
    private static final Component ABORT = ComponentBuilder.button("abort", new Object[0]);
    private final BaseScreen parent;
    private final List<Component> components;

    public YouSureScreen(BaseScreen parent, Component title, BaseScreen.OnConfirm onConfirm) {
        this(parent, (Component)title.copy().withStyle(ChatFormatting.RED), onConfirm, BaseScreen.DEFAULT_ABORT);
    }

    public YouSureScreen(BaseScreen parent, List<Component> components, BaseScreen.OnConfirm onConfirm) {
        this(parent, components.stream().map(component -> component.copy().withStyle(ChatFormatting.RED)).toList(), onConfirm, BaseScreen.DEFAULT_ABORT);
    }

    public YouSureScreen(BaseScreen parent, Component title, BaseScreen.OnConfirm onConfirm, BaseScreen.OnAbort onAbort) {
        this(parent, List.of(title), onConfirm, onAbort);
    }

    public YouSureScreen(BaseScreen parent, List<Component> components, BaseScreen.OnConfirm onConfirm, BaseScreen.OnAbort onAbort) {
        super(components.getFirst(), YouSureScreen.longestComponent(components) + 30, 80 + (components.size() - 1) * 16, onConfirm, onAbort);
        this.parent = parent;
        this.components = components;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CONFIRM, button -> {
            this.onConfirm.onConfirm();
            this.parent.onClose();
        }).bounds(this.centeredX(50) - 30, this.y(this.ySize - 35), 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ABORT, button -> this.onAbort.onAbort()).bounds(this.centeredX(50) + 30, this.y(this.ySize - 35), 50, 20).build());
    }

    @Override
    public void renderForeground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int i = 1; i < this.components.size(); ++i) {
            Component component = this.components.get(i);
            guiGraphics.drawString(this.font, component, this.centeredX(this.font.width(component.getVisualOrderText())), this.y((i + 1) * 16), Color.DARK_GRAY.getRGB(), false);
        }
    }

    private static int longestComponent(Collection<Component> components) {
        int longest = 0;
        for (Component component : components) {
            longest = Math.max(longest, TextHelper.stringLength((FormattedText)component));
        }
        return longest;
    }
}

