/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeamInfoScreen
extends BaseScreen {
    private static final MutableComponent CONFIG_SELF_MANAGEMENT = SkyComponents.DISABLED_JOIN_REQUEST;
    private static final MutableComponent TEAM_JOIN_REQUESTS = SkyComponents.DISABLED_TEAM_JOIN_REQUEST;
    private static final MutableComponent CONFIG_ALLOW_VISITS = SkyComponents.DISABLED_TEAM_VISIT;
    private static final MutableComponent TEAM_ALLOW_VISITS = SkyComponents.DISABLED_VISIT_TEAM;
    private static final MutableComponent USER_HAS_TEAM = SkyComponents.ERROR_USER_HAS_TEAM;
    private static final MutableComponent VISIT_TEAM = ComponentBuilder.text("visit_team", new Object[0]);
    private static final MutableComponent REQUEST_TO_JOIN = ComponentBuilder.text("request_to_join", new Object[0]);
    private static final MutableComponent REQUESTED_TO_JOIN = ComponentBuilder.text("requested_to_join", new Object[0]).withStyle(ChatFormatting.GREEN);
    private final Team team;
    private final BaseScreen prev;
    private Button visitButton;

    public TeamInfoScreen(Team team, BaseScreen prev) {
        super((Component)Component.literal((String)team.getName()), 245, 85);
        this.team = team;
        this.prev = prev;
    }

    protected void init() {
        Button joinButton = Button.builder((Component)(this.alreadySentJoinRequest() ? REQUESTED_TO_JOIN : REQUEST_TO_JOIN), button -> SkyGUIs.getNetwork().requestToJoinTeam(this.team)).bounds(this.x(10), this.y(30), 110, 20).build();
        if (SkyblockSavedData.get((Level)Minecraft.getInstance().level).hasPlayerTeam((Player)this.minecraft.player)) {
            joinButton.setTooltip(Tooltip.create((Component)USER_HAS_TEAM));
        } else if (!PermissionManager.INSTANCE.hasPermission((Player)this.minecraft.player, PermissionManager.Permission.TEAM_HANDLE_JOIN_REQUESTS)) {
            joinButton.setTooltip(Tooltip.create((Component)CONFIG_SELF_MANAGEMENT));
        } else if (!this.team.allowsJoinRequests()) {
            joinButton.setTooltip(Tooltip.create((Component)TEAM_JOIN_REQUESTS));
        }
        joinButton.active = PermissionManager.INSTANCE.hasPermission((Player)this.minecraft.player, PermissionManager.Permission.TEAM_HANDLE_JOIN_REQUESTS) && this.team.allowsJoinRequests() && !this.alreadySentJoinRequest() && !SkyblockSavedData.get((Level)Minecraft.getInstance().level).hasPlayerTeam((Player)this.minecraft.player);
        this.addRenderableWidget((GuiEventListener)joinButton);
        this.visitButton = Button.builder((Component)VISIT_TEAM, button -> SkyGUIs.getNetwork().teleportToTeam(this.team, SkyMeta.TeleportType.VISIT)).bounds(this.x(125), this.y(30), 110, 20).build();
        if (!this.minecraft.player.hasPermissions(1)) {
            if (!PermissionManager.INSTANCE.hasPermission((Player)this.minecraft.player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND)) {
                this.visitButton.setTooltip(Tooltip.create((Component)CONFIG_ALLOW_VISITS));
            } else if (!this.team.allowsVisits()) {
                this.visitButton.setTooltip(Tooltip.create((Component)TEAM_ALLOW_VISITS));
            }
        }
        this.visitButton.active = PermissionManager.INSTANCE.hasPermission((Player)this.minecraft.player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND) && (PermissionManager.INSTANCE.mayBypassLimitation((Player)this.minecraft.player) || this.team.allowsVisits());
        this.addRenderableWidget((GuiEventListener)this.visitButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.getInstance().setScreen((Screen)this.prev)).bounds(this.x(10), this.y(55), 226, 20).build());
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
    }

    public void tick() {
        super.tick();
        ClientLevel level = Minecraft.getInstance().level;
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        LocalPlayer player = this.minecraft.player;
        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND) && (PermissionManager.INSTANCE.mayBypassLimitation((Player)player) || this.team.allowsVisits())) {
            return;
        }
        SkyMeta metaInfo = data.getOrCreateMetaInfo((Player)player);
        if (metaInfo.canTeleport(SkyMeta.TeleportType.VISIT, level.getGameTime())) {
            this.visitButton.setTooltip(null);
            this.visitButton.active = true;
            return;
        }
        this.visitButton.setTooltip(Tooltip.create((Component)((Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.Cooldowns.visitCooldown - (level.getGameTime() - metaInfo.getLastTeleport(SkyMeta.TeleportType.VISIT))))))));
        this.visitButton.active = false;
    }

    private boolean alreadySentJoinRequest() {
        LocalPlayer player = this.minecraft.player;
        return player != null && this.team.getJoinRequests().contains(player.getUUID());
    }
}

