/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.edit.EditSpawnsScreen;
import de.melanx.skyguis.client.screen.edit.InvitablePlayersScreen;
import de.melanx.skyguis.client.screen.edit.TeamPlayersScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.client.widget.ValidatingEditBox;
import de.melanx.skyguis.network.handler.EditSpawns;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import de.melanx.skyguis.util.ToggleButtons;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TeamEditScreen
extends BaseScreen {
    private static final Component SPAWNS = ComponentBuilder.text("spawns", new Object[0]);
    private static final Component MEMBERS = ComponentBuilder.text("members", new Object[0]);
    private static final Component REQUESTS = ComponentBuilder.text("requests", new Object[0]);
    private static final Component ADD = ComponentBuilder.text("add", new Object[0]);
    private static final Component REMOVE = ComponentBuilder.text("remove", new Object[0]);
    private static final Component SHOW = ComponentBuilder.text("show", new Object[0]);
    private static final Component INVITE = ComponentBuilder.text("invite", new Object[0]);
    private static final Component ALLOW_VISITS = ComponentBuilder.text("allow_visits", new Object[0]);
    private static final Component ALLOW_REQUESTS = ComponentBuilder.text("allow_requests", new Object[0]);
    private static final MutableComponent VISIT_BASE = ComponentBuilder.button("allow_visits", new Object[0]).append((Component)Component.literal((String)" "));
    private static final MutableComponent REQUEST_BASE = ComponentBuilder.button("allow_requests", new Object[0]).append((Component)Component.literal((String)" "));
    private static final Component ALLOWED = ComponentBuilder.text("allowed", new Object[0]).withStyle(ChatFormatting.GREEN);
    private static final Component DISALLOWED = ComponentBuilder.text("disallowed", new Object[0]).withStyle(ChatFormatting.RED);
    private static final int LEFT_PADDING = 10;
    private static final int CHECKBOX_X = 10 + Math.max(TextHelper.stringLength((FormattedText)ALLOW_VISITS), TextHelper.stringLength((FormattedText)ALLOW_REQUESTS));
    private final Team team;
    private final BaseScreen prev;
    private final Random random;
    private ValidatingEditBox posBox;
    private Button addButton;
    private Button removeButton;
    private boolean posValid;

    public TeamEditScreen(Team team, BaseScreen prev) {
        super((Component)Component.literal((String)team.getName()), 245, 220);
        this.team = team;
        this.prev = prev;
        this.random = new Random();
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SHOW, button -> {
            assert (this.minecraft.player != null);
            if (!this.team.getPossibleSpawns().isEmpty()) {
                this.minecraft.player.sendSystemMessage((Component)SkyComponents.INFO_SHOW_TEAM_SPAWNS.apply(this.team.getName()));
            }
            for (TemplatesConfig.Spawn spawn : this.team.getPossibleSpawns()) {
                BlockPos pos = spawn.pos();
                double posX = (double)pos.getX() + 0.5;
                double posY = (double)pos.getY() + 0.5;
                double posZ = (double)pos.getZ() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double offsetX = this.random.nextGaussian() * 0.1;
                    double offsetY = this.random.nextGaussian() * 0.1;
                    double offsetZ = this.random.nextGaussian() * 0.1;
                    double speedX = this.random.nextGaussian() * 10.0;
                    double speedY = this.random.nextGaussian() * 10.0;
                    double speedZ = this.random.nextGaussian() * 10.0;
                    this.minecraft.level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, false, posX + offsetX, posY + offsetY, posZ + offsetZ, speedX, speedY, speedZ);
                }
                this.minecraft.player.sendSystemMessage((Component)Component.literal((String)" - ").append(RandomUtility.getFormattedPos((BlockPos)pos)));
            }
            this.onClose();
        }).bounds(this.x(10), this.y(45), 70, 20).build());
        CycleButton directionButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(TeamEditScreen::componentFromDirection).withValues((Object[])WorldUtil.SpawnDirection.values()).withInitialValue((Object)WorldUtil.SpawnDirection.SOUTH).displayOnlyValue().create(this.x(160), this.y(70), 70, 20, (Component)Component.empty()));
        this.addButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ADD, button -> {
            BlockPos pos = this.getPos();
            if (this.posValid && pos != null) {
                SkyGUIs.getNetwork().handleEditSpawns(EditSpawns.Type.ADD, pos, (WorldUtil.SpawnDirection)directionButton.getValue());
            }
        }).bounds(this.x(85), this.y(45), 70, 20).build());
        this.removeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)REMOVE, button -> Minecraft.getInstance().setScreen((Screen)new EditSpawnsScreen(this.team, this))).tooltip(Tooltip.create((Component)BaseScreen.OPEN_NEW_SCREEN)).bounds(this.x(160), this.y(45), 70, 20).build());
        Vec3 pos = Minecraft.getInstance().player.position();
        String posStr = (int)pos.x + " " + (int)pos.y + " " + (int)pos.z;
        this.posBox = new ValidatingEditBox(this.font, this.x(10), this.y(71), 145, 18, (Component)Component.literal((String)posStr), this::updatePositionValidation);
        this.posBox.setValue(posStr);
        this.posBox.setMaxLength(Short.MAX_VALUE);
        this.addRenderableWidget((GuiEventListener)this.posBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SHOW, button -> Minecraft.getInstance().setScreen((Screen)new TeamPlayersScreen(this.team, this))).bounds(this.x(10), this.y(115), 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)INVITE, button -> Minecraft.getInstance().setScreen((Screen)new InvitablePlayersScreen(this.team, this))).bounds(this.x(105), this.y(115), 90, 20).build());
        this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(CHECKBOX_X + 5), this.y(147), 10, this.team.allowsVisits(), (Component)VISIT_BASE.copy().append(this.team.allowsVisits() ? ALLOWED : DISALLOWED), (checkbox, value) -> ToggleButtons.toggleState(this.team, (AbstractWidget)checkbox, VISIT_BASE, ToggleButtons.Type.VISITS)));
        this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(CHECKBOX_X + 5), this.y(162), 10, this.team.allowsJoinRequests(), (Component)REQUEST_BASE.copy().append(this.team.allowsJoinRequests() ? ALLOWED : DISALLOWED), (checkbox, value) -> ToggleButtons.toggleState(this.team, (AbstractWidget)checkbox, REQUEST_BASE, ToggleButtons.Type.JOIN_REQUEST)));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.button("leave_team", new Object[0]), button -> Minecraft.getInstance().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, List.of(ComponentBuilder.text("you_sure_leave0", new Object[0]), ComponentBuilder.text("you_sure_leave1", new Object[0])), () -> SkyGUIs.getNetwork().leaveTeam((Player)Minecraft.getInstance().player)))).bounds(this.x(CHECKBOX_X + 25), this.y(150), 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.getInstance().setScreen((Screen)this.prev)).bounds(this.x(10), this.y(this.ySize - 30), 226, 20).build());
        if (!PermissionManager.INSTANCE.hasPermission((Player)Minecraft.getInstance().player, PermissionManager.Permission.EDIT_SPAWNS)) {
            this.addButton.active = false;
            this.removeButton.active = false;
        }
    }

    private static Component componentFromDirection(WorldUtil.SpawnDirection direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case WorldUtil.SpawnDirection.NORTH -> ComponentBuilder.text("north", new Object[0]);
            case WorldUtil.SpawnDirection.SOUTH -> ComponentBuilder.text("south", new Object[0]);
            case WorldUtil.SpawnDirection.EAST -> ComponentBuilder.text("east", new Object[0]);
            case WorldUtil.SpawnDirection.WEST -> ComponentBuilder.text("west", new Object[0]);
        };
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        guiGraphics.drawString(this.font, SPAWNS, this.x(10), this.y(30), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, MEMBERS, this.x(10), this.y(100), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, ALLOW_VISITS, this.x(10), this.y(149), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, ALLOW_REQUESTS, this.x(10), this.y(164), Color.DARK_GRAY.getRGB(), false);
        this.posBox.updateOutlineRendering(this.addButton.isHovered);
    }

    private void updatePositionValidation() {
        String posBoxValue = this.posBox.getValue();
        String[] args = posBoxValue.split(" ");
        boolean bl = this.posValid = args.length == 3 && Arrays.stream(args).allMatch(s -> {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }) && Integer.parseInt(args[1]) >= Minecraft.getInstance().level.getMinBuildHeight() && Integer.parseInt(args[1]) <= Minecraft.getInstance().level.getMaxBuildHeight() && !this.team.getPossibleSpawns().stream().map(TemplatesConfig.Spawn::pos).collect(Collectors.toSet()).contains(new BlockPos(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2])));
        if (this.posValid) {
            this.posBox.setValid();
            if (PermissionManager.INSTANCE.hasPermission((Player)Minecraft.getInstance().player, PermissionManager.Permission.EDIT_SPAWNS)) {
                this.addButton.active = true;
                this.removeButton.active = true;
            }
        } else {
            this.posBox.setInvalid();
            this.addButton.active = false;
            this.removeButton.active = false;
        }
    }

    @Nullable
    private BlockPos getPos() {
        if (this.posValid) {
            String value = this.posBox.getValue();
            String[] args = value.split(" ");
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            int z = Integer.parseInt(args[2]);
            return new BlockPos(x, y, z);
        }
        return null;
    }
}

