/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class GrindingRecipe
extends MultipleOutputFurnaceRecipe {
    public GrindingRecipe(String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float secondaryChance, float experience, int processTime) {
        super(ForceRecipes.GRINDING.get(), groupIn, ingredientIn, results, secondaryChance, experience, processTime);
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ForceRegistry.GRINDING_CORE.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.GRINDING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<GrindingRecipe> {
        private static final MapCodec<GrindingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> ((GrindingRecipe)recipe).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((GrindingRecipe)recipe).ingredient), (App)ItemStack.CODEC.listOf().fieldOf("results").flatXmap(array -> {
            Object[] stacks = (ItemStack[])array.toArray(ItemStack[]::new);
            if (stacks.length == 0) {
                return DataResult.error(() -> "No results for freezing recipe");
            }
            return stacks.length > MultipleOutputFurnaceRecipe.MAX_OUTPUT ? DataResult.error(() -> "Too many itemstacks for freezing recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks));
        }, DataResult::success).forGetter(recipe -> recipe.results), (App)Codec.FLOAT.fieldOf("secondaryChance").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.secondaryChance)), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((GrindingRecipe)recipe).experience)), (App)Codec.INT.fieldOf("processTime").orElse((Object)200).forGetter(recipe -> ((GrindingRecipe)recipe).cookingTime)).apply((Applicative)instance, GrindingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GrindingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<GrindingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GrindingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static GrindingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList resultList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer)));
            }
            float chance = buffer.readFloat();
            float f = buffer.readFloat();
            int i = buffer.readVarInt();
            return new GrindingRecipe(s, ingredient, (NonNullList<ItemStack>)resultList, chance, f, i);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, GrindingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeVarInt(recipe.results.size());
            for (ItemStack stack : recipe.results) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)stack);
            }
            buffer.writeFloat(recipe.secondaryChance);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookingTime);
        }
    }
}

