/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.handler;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.card.RecipeContentsData;
import com.mrbysco.forcecraft.components.storage.BeltStorage;
import com.mrbysco.forcecraft.components.storage.PackStorage;
import com.mrbysco.forcecraft.components.storage.StorageManager;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.menu.ForceBeltMenu;
import com.mrbysco.forcecraft.menu.ForcePackMenu;
import com.mrbysco.forcecraft.menu.ItemCardMenu;
import com.mrbysco.forcecraft.networking.message.OpenInventoryPayload;
import com.mrbysco.forcecraft.networking.message.PackChangePayload;
import com.mrbysco.forcecraft.networking.message.QuickUseBeltPayload;
import com.mrbysco.forcecraft.networking.message.RecipeToCardPayload;
import com.mrbysco.forcecraft.networking.message.SaveCardRecipePayload;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.FindingUtil;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpen(OpenInventoryPayload openData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (openData.inventoryType() == 0) {
                    ItemStack beltStack;
                    stackPredicate = stack -> stack.getItem() instanceof ForceBeltItem;
                    if (FindingUtil.hasSingleStackInHotbar((Player)player, stackPredicate) && !(beltStack = FindingUtil.findInstanceStack((Player)player, stackPredicate)).isEmpty()) {
                        Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                        data.ifPresent(belt -> player.openMenu((MenuProvider)new SimpleMenuProvider((id, pInv, pEntity) -> new ForceBeltMenu(id, pInv, belt.getInventory()), (Component)(beltStack.has(DataComponents.CUSTOM_NAME) ? ((MutableComponent)beltStack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.belt")))));
                    }
                } else {
                    ItemStack packStack;
                    stackPredicate = stack -> stack.getItem() instanceof ForcePackItem;
                    if (FindingUtil.hasSingleStackInHotbar((Player)player, stackPredicate) && !(packStack = FindingUtil.findInstanceStack((Player)player, stackPredicate)).isEmpty()) {
                        Optional<PackStorage> data = StorageManager.getPack(packStack);
                        data.ifPresent(pack -> player.openMenu((MenuProvider)new SimpleMenuProvider((id, pInv, pEntity) -> new ForcePackMenu(id, pInv, pack.getInventory()), (Component)(packStack.has(DataComponents.CUSTOM_NAME) ? ((MutableComponent)packStack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.pack"))), buf -> buf.writeInt(pack.getInventory().getUpgrades())));
                    }
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"forcecraft.networking.open_inventory.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleQuickUse(QuickUseBeltPayload beltData, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack beltStack;
            Predicate<ItemStack> stackPredicate;
            ServerPlayer player;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && FindingUtil.hasSingleStackInHotbar((Player)(player = (ServerPlayer)patt0$temp), stackPredicate = stack -> stack.getItem() instanceof ForceBeltItem) && !(beltStack = FindingUtil.findInstanceStack((Player)player, stackPredicate)).isEmpty()) {
                Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                data.ifPresent(belt -> {
                    IItemHandler handler = belt.getInventory();
                    ItemStack stack = handler.getStackInSlot(beltData.slot());
                    Level level = player.level();
                    if (!stack.isEmpty()) {
                        stack.finishUsingItem(level, (LivingEntity)player);
                        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), stack.getDrinkingSound(), player.getSoundSource(), 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
                    }
                });
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"forcecraft.networking.quick_use_belt.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handlePackChange(PackChangePayload changeData, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            ItemStack stack;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && ((stack = (player = (ServerPlayer)patt0$temp).getItemInHand(changeData.hand())).getItem() == ForceRegistry.FORCE_PACK.get() || stack.getItem() == ForceRegistry.FORCE_BELT.get())) {
                stack.set(ForceComponents.PACK_COLOR, (Object)changeData.color());
                String customName = changeData.customName();
                if (customName.isEmpty()) {
                    stack.remove(DataComponents.CUSTOM_NAME);
                } else if (!stack.getHoverName().getString().equals(customName)) {
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)customName).withStyle(ChatFormatting.YELLOW));
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"forcecraft.networking.pack_change.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleCard(RecipeToCardPayload recipeData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                AbstractContainerMenu patt1$temp;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack mainhand = ItemStack.EMPTY;
                if (player.getMainHandItem().getItem() instanceof ItemCardItem) {
                    mainhand = player.getMainHandItem();
                } else if (player.getOffhandItem().getItem() instanceof ItemCardItem) {
                    mainhand = player.getOffhandItem();
                }
                if (!mainhand.isEmpty() && mainhand.getItem() == ForceRegistry.ITEM_CARD.get() && (patt1$temp = player.containerMenu) instanceof ItemCardMenu) {
                    ItemCardMenu itemCardContainer = (ItemCardMenu)patt1$temp;
                    itemCardContainer.setMatrixContents((Player)player, recipeData.stacks());
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"forcecraft.networking.recipe_to_card.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSaveCard(SaveCardRecipePayload saveData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                AbstractContainerMenu patt1$temp;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                Level level = player.level();
                ItemStack stack = ServerPayloadHandler.getCardStack((Player)player);
                if (!stack.isEmpty() && (patt1$temp = player.containerMenu) instanceof ItemCardMenu) {
                    ItemCardMenu itemCardContainer = (ItemCardMenu)patt1$temp;
                    CraftingContainer craftMatrix = itemCardContainer.getCraftMatrix();
                    ResultContainer craftResult = itemCardContainer.getCraftResult();
                    Optional iRecipe = player.server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftMatrix.asCraftInput(), level);
                    iRecipe.ifPresent(holder -> {
                        CompoundTag recipeContents = new CompoundTag();
                        if (craftMatrix.getContainerSize() > 9) {
                            player.sendSystemMessage((Component)Component.translatable((String)"forcecraft.networking.save_card.too_large", (Object[])new Object[]{"Crafting grid too large"}).withStyle(ChatFormatting.RED));
                            return;
                        }
                        NonNullList stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
                        for (int i = 0; i < craftMatrix.getContainerSize(); ++i) {
                            stacks.set(i, (Object)craftMatrix.getItem(i));
                        }
                        RecipeContentsData data = new RecipeContentsData((NonNullList<ItemStack>)stacks, craftResult.getItem(0));
                        stack.set(ForceComponents.RECIPE_CONTENTS, (Object)data);
                    });
                }
                player.sendSystemMessage((Component)Component.literal((String)"Recipe saved").withStyle(ChatFormatting.YELLOW));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"forcecraft.networking.save_card.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private static ItemStack getCardStack(Player player) {
        if (player.getMainHandItem().getItem() instanceof ItemCardItem) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof ItemCardItem) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }
}

