/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.furnace.slot;

import com.mrbysco.forcecraft.blockentities.furnace.AbstractForceFurnaceBlockEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ForceFurnaceResultSlot
extends SlotItemHandler {
    private final Player player;
    protected int removeCount;

    public ForceFurnaceResultSlot(Player player, IItemHandler inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(inventoryIn, slotIndex, xPosition, yPosition);
        this.player = player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(thePlayer, stack);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        Container container;
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        if (this.player instanceof ServerPlayer && (container = this.container) instanceof AbstractForceFurnaceBlockEntity) {
            AbstractForceFurnaceBlockEntity forceFurnaceBlockEntity = (AbstractForceFurnaceBlockEntity)container;
            forceFurnaceBlockEntity.awardUsedRecipesAndPopExperience((ServerPlayer)this.player);
        }
        this.removeCount = 0;
        EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
    }
}

