/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.menu.slot.BeltSlot;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.FindingUtil;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ForceBeltMenu
extends AbstractContainerMenu {
    private ItemStack heldStack;
    private IItemHandler itemHandler;

    public boolean stillValid(Player playerIn) {
        return !playerIn.isSpectator() && !this.heldStack.isEmpty();
    }

    public static ForceBeltMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        return new ForceBeltMenu(windowId, playerInventory, (IItemHandler)new ItemStackHandler(8){

            public boolean isItemValid(int slot, ItemStack stack) {
                return ForceBeltItem.filter(stack);
            }
        });
    }

    public ForceBeltMenu(int id, Inventory playerInventory, IItemHandler handler) {
        super(ForceMenus.FORCE_BELT.get(), id);
        this.heldStack = FindingUtil.findInstanceStack(playerInventory.player, stack -> stack.getItem() instanceof ForceBeltItem);
        if (this.heldStack == null || this.heldStack.isEmpty()) {
            playerInventory.player.closeContainer();
            return;
        }
        int xPosC = 17;
        int yPosC = 20;
        this.itemHandler = handler;
        if (this.itemHandler != null) {
            for (int k = 0; k < 8; ++k) {
                this.addSlot((Slot)new BeltSlot(this.itemHandler, k, xPosC + k * 18, yPosC));
            }
            int xPos = 8;
            int yPos = 54;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
            }
        } else {
            playerInventory.player.closeContainer();
        }
    }

    public void removed(Player playerIn) {
        if (this.itemHandler != null) {
            this.heldStack.set(ForceComponents.SLOTS_USED, (Object)ItemHandlerUtils.getUsedSlots(this.itemHandler));
            this.heldStack.set(ForceComponents.SLOTS_TOTAL, (Object)this.itemHandler.getSlots());
        }
        super.removed(playerIn);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && this.getSlot(slotId).getItem().getItem() instanceof ForceBeltItem) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (itemstack.getItem() instanceof ForceBeltItem) {
                return ItemStack.EMPTY;
            }
            int containerSlots = this.slots.size() - player.getInventory().items.size();
            if (index < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

