/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.items.tools.ForceArrowItem;
import com.mrbysco.forcecraft.util.TooltipUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class ForceBowItem
extends BowItem
implements IForceChargingTool {
    public static final Predicate<ItemStack> FORCE_ARROWS = stack -> stack.getItem() instanceof ForceArrowItem;

    public ForceBowItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(332));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        Player player;
        ItemStack itemstack;
        if (livingEntity instanceof Player && !(itemstack = (player = (Player)livingEntity).getProjectile(stack)).isEmpty()) {
            int i = this.getUseDuration(stack, livingEntity) - timeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = ForceBowItem.getPowerForTime((int)i);
            if (!((double)f < 0.1)) {
                List list = ForceBowItem.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        TooltipUtil.addForceTooltips(stack, tooltip);
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return FORCE_ARROWS;
    }
}

