/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public record UpgradeBookData(UpgradeBookTier tier, List<ResourceLocation> recipesUsed, int points, String progressCache) {
    public static final UpgradeBookData DEFAULT = new UpgradeBookData(UpgradeBookTier.ZERO, new ArrayList<ResourceLocation>(), 0, "");
    public static final Codec<UpgradeBookData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)UpgradeBookTier.CODEC.fieldOf("tier").forGetter(UpgradeBookData::tier), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("recipesUsed").forGetter(UpgradeBookData::recipesUsed), (App)Codec.INT.fieldOf("points").forGetter(UpgradeBookData::points), (App)Codec.STRING.fieldOf("progressCache").forGetter(UpgradeBookData::progressCache)).apply((Applicative)inst, UpgradeBookData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeBookData> STREAM_CODEC = StreamCodec.of(UpgradeBookData::toNetwork, UpgradeBookData::fromNetwork);

    private static UpgradeBookData fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        UpgradeBookTier tier = UpgradeBookTier.values()[byteBuf.readVarInt()];
        List recipesUsed = byteBuf.readList((StreamDecoder)ResourceLocation.STREAM_CODEC);
        int points = byteBuf.readVarInt();
        String progressCache = byteBuf.readUtf(Short.MAX_VALUE);
        return new UpgradeBookData(tier, recipesUsed, points, progressCache);
    }

    private static void toNetwork(RegistryFriendlyByteBuf byteBuf, UpgradeBookData playerCompassData) {
        byteBuf.writeVarInt(playerCompassData.tier().ordinal());
        byteBuf.writeCollection(playerCompassData.recipesUsed(), (StreamEncoder)ResourceLocation.STREAM_CODEC);
        byteBuf.writeVarInt(playerCompassData.points());
        byteBuf.writeUtf(playerCompassData.progressCache());
    }

    public int nextTier(ItemStack stack) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        if (data.tier() == UpgradeBookTier.FINAL) {
            return 0;
        }
        return Math.max(0, data.tier().pointsForLevelup() - this.points);
    }

    public void onRecipeApply(RecipeHolder<InfuseRecipe> recipeHolder, ItemStack bookStack) {
        ArrayList<ResourceLocation> recipesUsed;
        UpgradeBookData data = (UpgradeBookData)bookStack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        if (InfuserBlockEntity.LEVEL_RECIPE_LIST.get(data.tier.asInt()).contains(recipeHolder.id()) && !(recipesUsed = new ArrayList<ResourceLocation>(data.recipesUsed())).contains(recipeHolder.id())) {
            recipesUsed.add(recipeHolder.id());
            bookStack.set(ForceComponents.UPGRADE_BOOK, (Object)new UpgradeBookData(data.tier, recipesUsed, data.points, data.progressCache));
        }
        UpgradeBookData.tryLevelUp(bookStack);
    }

    public static void incrementPoints(ItemStack stack, int incoming) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        stack.set(ForceComponents.UPGRADE_BOOK, (Object)new UpgradeBookData(data.tier, data.recipesUsed, data.points + incoming, data.progressCache));
        UpgradeBookData.tryLevelUp(stack);
    }

    private static void tryLevelUp(ItemStack stack) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        if (UpgradeBookData.canLevelUp(stack)) {
            int newPoints = data.points() - data.tier().pointsForLevelup();
            UpgradeBookData.setTierAndPoints(stack, data.tier().incrementTier(), newPoints);
            UpgradeBookData.updateCache(stack);
        }
    }

    private static void updateCache(ItemStack stack) {
        int recipesThisTier;
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        List<ResourceLocation> thisTier = InfuserBlockEntity.LEVEL_RECIPE_LIST.get(data.tier().ordinal());
        List<ResourceLocation> usedRecipes = data.recipesUsed();
        ForceCraft.LOGGER.info("thisTier {}", thisTier);
        ForceCraft.LOGGER.info("RecipesUsed {}", usedRecipes);
        int n = recipesThisTier = usedRecipes == null ? 0 : usedRecipes.size();
        if (!InfuserBlockEntity.LEVEL_RECIPE_LIST.isEmpty()) {
            int totalThisTier = thisTier.size();
            stack.set(ForceComponents.UPGRADE_BOOK, (Object)new UpgradeBookData(data.tier, data.recipesUsed, data.points, recipesThisTier + "/" + totalThisTier));
        }
    }

    private static boolean canLevelUp(ItemStack stack) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        List<ResourceLocation> thisTier = data.recipesUsed();
        int recipesThisTier = thisTier == null ? 0 : thisTier.size();
        int totalThisTier = InfuserBlockEntity.LEVEL_RECIPE_LIST.get(data.tier().ordinal()).size();
        UpgradeBookData.updateCache(stack);
        if (data.points() < data.tier().pointsForLevelup() || data.tier() == UpgradeBookTier.FINAL) {
            return false;
        }
        return recipesThisTier >= totalThisTier;
    }

    private static void setTierAndPoints(ItemStack stack, UpgradeBookTier tier, int points) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        stack.set(ForceComponents.UPGRADE_BOOK, (Object)new UpgradeBookData(tier, new ArrayList<ResourceLocation>(), points, data.progressCache));
    }

    public static void setTier(ItemStack stack, UpgradeBookTier tier) {
        UpgradeBookData data = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)DEFAULT);
        stack.set(ForceComponents.UPGRADE_BOOK, (Object)new UpgradeBookData(tier, new ArrayList<ResourceLocation>(), data.points, data.progressCache));
    }
}

