/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.flask.ForceFlaskItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ForceFilledForceFlask
extends BaseItem {
    public ForceFilledForceFlask(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!level.isClientSide) {
            entityLiving.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 2, false, false));
        }
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)entityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayerentity, stack);
            serverplayerentity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        ItemStack flaskStack = ((ForceFlaskItem)((Object)ForceRegistry.FORCE_FLASK.get())).getDefaultInstance();
        if (entityLiving instanceof Player) {
            Player playerIn = (Player)entityLiving;
            stack.consume(1, (LivingEntity)playerIn);
            if (!playerIn.getInventory().add(flaskStack)) {
                playerIn.spawnAtLocation(flaskStack, 0.0f);
            }
        }
        return stack.isEmpty() ? flaskStack : stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)playerIn, (InteractionHand)handIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)"item.force_filled_force_flask.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

