/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.card.RecipeContentsData;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.ItemCardMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCardItem
extends BaseItem {
    private static final Component BAD_READ = Component.literal((String)"BAD READ. TRY AGAIN.").withStyle(ChatFormatting.RED);
    private static final Component TOO_SLOW = Component.literal((String)"TOO SLOW. TRY AGAIN.").withStyle(ChatFormatting.RED);
    private static final Component TOO_FAST = Component.literal((String)"TOO FAST. TRY AGAIN.").withStyle(ChatFormatting.RED);

    public ItemCardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown() && !level.isClientSide) {
            playerIn.openMenu(this.getContainer(level, playerIn.blockPosition()), playerIn.blockPosition());
        }
        return super.use(level, playerIn, handIn);
    }

    @Nullable
    public MenuProvider getContainer(Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new ItemCardMenu(id, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), (Component)Component.translatable((String)"forcecraft.container.card"));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Level level = playerIn.level();
        level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (level.isClientSide) {
            int rand = playerIn.getRandom().nextInt(3);
            Component message = switch (rand) {
                case 1 -> TOO_SLOW;
                case 2 -> TOO_FAST;
                default -> BAD_READ;
            };
            playerIn.displayClientMessage(message, true);
        }
        return super.interactLivingEntity(stack, playerIn, target, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (stack.has(ForceComponents.RECIPE_CONTENTS)) {
            RecipeContentsData contentsData = (RecipeContentsData)stack.get(ForceComponents.RECIPE_CONTENTS);
            if (contentsData != null) {
                ItemStack resultStack = contentsData.resultItem();
                tooltip.add((Component)Component.translatable((String)"forcecraft.item_card.recipe_output", (Object[])new Object[]{Component.literal((String)(resultStack.getCount() + " " + resultStack.getHoverName().getString())).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.YELLOW));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"forcecraft.item_card.unset").withStyle(ChatFormatting.RED));
        }
        tooltip.add((Component)Component.literal((String)" "));
        tooltip.add((Component)Component.translatable((String)"forcecraft.item_card.recipe_set").withStyle(ChatFormatting.BOLD));
    }
}

