/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.storage.BeltStorage;
import com.mrbysco.forcecraft.components.storage.StorageManager;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.ForceBeltMenu;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceBeltItem
extends BaseItem {
    public ForceBeltItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            if (level.isClientSide) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!level.isClientSide) {
            BeltStorage data = StorageManager.getOrCreateBelt(stack);
            playerIn.openMenu(this.getContainer(stack, data.getInventory()));
        }
        return super.use(level, playerIn, handIn);
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack, IItemHandler handler) {
        return new SimpleMenuProvider((id, inventory, player) -> new ForceBeltMenu(id, inventory, handler), (Component)(stack.has(DataComponents.CUSTOM_NAME) ? ((MutableComponent)stack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.belt")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (stack.has(ForceComponents.SLOTS_USED) && stack.has(ForceComponents.SLOTS_TOTAL)) {
            tooltip.add((Component)Component.literal((String)String.format("%s/%s Slots", stack.getOrDefault(ForceComponents.SLOTS_USED, (Object)0), stack.getOrDefault(ForceComponents.SLOTS_TOTAL, (Object)1))));
        } else {
            tooltip.add((Component)Component.literal((String)"0/8 Slots"));
        }
        if (flagIn.isAdvanced() && stack.has(ForceComponents.UUID)) {
            UUID uuid = (UUID)stack.get(ForceComponents.UUID);
            tooltip.add((Component)Component.literal((String)("ID: " + uuid.toString().substring(0, 8))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public Component getName(ItemStack stack) {
        return ((MutableComponent)super.getName(stack)).withStyle(ChatFormatting.YELLOW);
    }

    public static boolean filter(ItemStack stack) {
        return !(stack.getItem() instanceof ForceBeltItem) && stack.is(ForceTags.VALID_FORCE_BELT);
    }
}

