/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.util.TooltipUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ForceArmorItem
extends ArmorItem
implements IForceChargingTool {
    public ForceArmorItem(Holder<ArmorMaterial> materialIn, ArmorItem.Type type, Item.Properties builderIn) {
        super(materialIn, type, builderIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        TooltipUtil.addForceTooltips(stack, tooltip);
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        if (stack.has(ForceComponents.TOOL_CAMO)) {
            return Reference.modLoc("textures/models/armor/force_invisible.png");
        }
        return super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }
}

