/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ExperienceTomeItem
extends Item {
    public static final int CAPACITY = Integer.MAX_VALUE;

    public ExperienceTomeItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"forcecraft.tooltip.press_shift"));
            return;
        }
        tooltip.add((Component)Component.literal((String)(Float.toString(ExperienceTomeItem.getExperience(stack)) + " / " + Float.toString(ExperienceTomeItem.getMaxExperience(stack)))));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ForceUtils.isFakePlayer((Entity)player) || hand != InteractionHand.MAIN_HAND || level.isClientSide) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        int curLevel = player.experienceLevel;
        if (player.isShiftKeyDown()) {
            int exp = ExperienceTomeItem.getExtraPlayerExperience(player) > 0 ? Math.min(ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel + 1) - ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel) - ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getExperience(stack)) : Math.min(ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel + 1) - ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel), ExperienceTomeItem.getExperience(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) + exp);
            if (player.experienceLevel < curLevel + 1 && ExperienceTomeItem.getPlayerExperience(player) >= ExperienceTomeItem.getTotalExpForLevel(curLevel + 1)) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel + 1);
            }
            ExperienceTomeItem.modifyExperience(stack, -exp);
        } else if (ExperienceTomeItem.getExtraPlayerExperience(player) > 0) {
            int exp = Math.min(ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.experienceLevel < curLevel) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        } else if (player.experienceLevel > 0) {
            int exp = Math.min(ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel) - ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel - 1), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.experienceLevel < curLevel - 1) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel - 1);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public static int getPlayerExperience(Player player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel) + ExperienceTomeItem.getExtraPlayerExperience(player);
    }

    public static int getLevelPlayerExperience(Player player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.experienceLevel);
    }

    public static int getExtraPlayerExperience(Player player) {
        return Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void setPlayerExperience(Player player, int exp) {
        player.experienceLevel = 0;
        player.experienceProgress = 0.0f;
        player.totalExperience = 0;
        ExperienceTomeItem.addExperienceToPlayer(player, exp);
    }

    public static void setPlayerLevel(Player player, int level) {
        player.experienceLevel = level;
        player.experienceProgress = 0.0f;
    }

    public static void addExperienceToPlayer(Player player, int exp) {
        int i = Integer.MAX_VALUE - player.totalExperience;
        if (exp > i) {
            exp = i;
        }
        player.experienceProgress += (float)exp / (float)player.getXpNeededForNextLevel();
        player.totalExperience += exp;
        while (player.experienceProgress >= 1.0f) {
            player.experienceProgress = (player.experienceProgress - 1.0f) * (float)player.getXpNeededForNextLevel();
            ExperienceTomeItem.addExperienceLevelToPlayer(player, 1);
            player.experienceProgress /= (float)player.getXpNeededForNextLevel();
        }
    }

    public static void addExperienceLevelToPlayer(Player player, int levels) {
        player.experienceLevel += levels;
        if (player.experienceLevel < 0) {
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
            player.totalExperience = 0;
        }
    }

    public static int getTotalExpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }

    public static void modifyExperience(ItemStack stack, int exp) {
        int storedExp = ExperienceTomeItem.getExperience(stack) + exp;
        if (storedExp > ExperienceTomeItem.getMaxExperience(stack)) {
            storedExp = ExperienceTomeItem.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        stack.set(ForceComponents.TOME_EXPERIENCE, (Object)storedExp);
    }

    public static int getExperience(ItemStack stack) {
        return (Integer)stack.getOrDefault(ForceComponents.TOME_EXPERIENCE, (Object)0);
    }

    public static int getMaxExperience(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public static int getSpace(ItemStack stack) {
        return ExperienceTomeItem.getMaxExperience(stack) - ExperienceTomeItem.getExperience(stack);
    }
}

