/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BaconatorItem
extends BaseItem {
    public static final String HAS_FOOD_TAG = "forcecraft:hasItems";

    public BaconatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        FoodProperties foodProperties;
        ItemStack firstStack;
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        IItemHandler handler = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
        if (playerIn.isShiftKeyDown()) {
            boolean isFull = ItemHandlerUtils.isFull(handler);
            if (!isFull) {
                boolean extracted = ItemHandlerUtils.extractStackFromPlayer(playerIn.getInventory(), handler, stack -> !stack.isEmpty() && stack.has(DataComponents.FOOD) && stack.is(ForceTags.BACONATOR_FOOD));
                boolean hasItems = ItemHandlerUtils.hasItems(handler);
                if (!extracted) {
                    if (hasItems) {
                        itemstack.setDamageValue(itemstack.getDamageValue() == 1 ? 0 : 1);
                    }
                } else {
                    level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else if (ItemHandlerUtils.hasItems(handler) && !(firstStack = ItemHandlerUtils.getFirstItem(handler)).isEmpty() && (foodProperties = firstStack.getFoodProperties((LivingEntity)playerIn)) != null && playerIn.canEat(foodProperties.canAlwaysEat())) {
            playerIn.startUsingItem(handIn);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (firstStack != null && !firstStack.isEmpty()) {
            entityLiving.eat(level, firstStack);
            level.playSound((Player)null, entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), SoundEvents.PIG_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        return firstStack != null && firstStack.has(DataComponents.FOOD) ? UseAnim.EAT : UseAnim.NONE;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.getDamageValue() == 1 && entityIn instanceof Player) {
            IItemHandler handler;
            ItemStack firstStack;
            Player playerIn = (Player)entityIn;
            if (level.getGameTime() % 20L == 0L && !playerIn.getAbilities().instabuild && playerIn.canEat(false) && stack.has(ForceComponents.STORED_FOOD) && !(firstStack = ItemHandlerUtils.getFirstItem(handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM))).isEmpty()) {
                playerIn.eat(level, firstStack);
                level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.PIG_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (!firstStack.isEmpty() && firstStack.has(DataComponents.FOOD)) {
            FoodProperties foodProperties = firstStack.getFoodProperties(livingEntity);
            return foodProperties.eatDurationTicks();
        }
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return stack.getDamageValue() == 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"forcecraft.baconator.shift.carrying").withStyle(ChatFormatting.DARK_RED));
            IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            if (handler != null) {
                int stacks = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack foodStack = handler.getStackInSlot(i);
                    if (foodStack.isEmpty()) continue;
                    tooltip.add((Component)Component.literal((String)(foodStack.getCount() + "x ")).append(foodStack.getHoverName()).withStyle(ChatFormatting.GOLD));
                    ++stacks;
                }
                if (stacks == 0) {
                    tooltip.add((Component)Component.translatable((String)"forcecraft.baconator.shift.nothing").withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"forcecraft.baconator.shift.text").withStyle(ChatFormatting.GRAY));
        }
    }
}

