/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.attachments.ForceAttachments;
import com.mrbysco.forcecraft.attachments.playermodifier.PlayerModifierAttachment;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PlayerCapHandler {
    private static final int SPEED_DURATION = 200;

    @SubscribeEvent
    public void onPlayerUpdate(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Iterable armor = player2.getArmorSlots();
            int speed = 0;
            for (ItemStack slotSelected : armor) {
                if (!(slotSelected.getItem() instanceof ForceArmorItem)) continue;
                speed += ((Integer)slotSelected.getOrDefault(ForceComponents.TOOL_SPEED, (Object)0)).intValue();
            }
            if (speed > 0) {
                MobEffectInstance speedEffect = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, speed - 1, false, false);
                if (!player2.hasEffect(MobEffects.MOVEMENT_SPEED) || player2.hasEffect(MobEffects.MOVEMENT_SPEED) && player2.getEffect(MobEffects.MOVEMENT_SPEED).getDuration() <= 100) {
                    player2.addEffect(speedEffect);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerCapHandler.updateArmorProperties(event.getEntity());
    }

    @SubscribeEvent
    public void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerCapHandler.updateArmorProperties(player);
        }
    }

    public static void updateArmorProperties(Player player) {
        Iterable armor = player.getArmorSlots();
        int armorPieces = 0;
        int damage = 0;
        int heat = 0;
        int luck = 0;
        int bane = 0;
        int bleed = 0;
        for (ItemStack slotSelected : armor) {
            if (!(slotSelected.getItem() instanceof ForceArmorItem)) continue;
            ++armorPieces;
            damage += (int)((double)((Integer)slotSelected.getOrDefault(ForceComponents.TOOL_SHARPNESS, (Object)0)).intValue() * (Double)ConfigHandler.COMMON.forcePunchDamage.get());
            if (slotSelected.has(ForceComponents.TOOL_HEAT)) {
                ++heat;
            }
            if (slotSelected.has(ForceComponents.TOOL_LUCK)) {
                ++luck;
            }
            if (slotSelected.has(ForceComponents.TOOL_BANE)) {
                ++bane;
            }
            if (!slotSelected.has(ForceComponents.TOOL_BLEED)) continue;
            bleed += ((Integer)slotSelected.getOrDefault(ForceComponents.TOOL_BLEED, (Object)0)).intValue();
        }
        PlayerModifierAttachment attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD);
        int finalArmorPieces = armorPieces;
        attachment.setArmorPieces(finalArmorPieces);
        int finalDamage = damage;
        attachment.setAttackDamage(1.0f * (float)finalDamage);
        int finalHeat = heat;
        attachment.setHeatPieces(finalHeat);
        attachment.setHeatDamage(2.0f * (float)finalHeat);
        int finalLuck = luck;
        attachment.setLuckLevel(finalLuck);
        int finalBane = bane;
        attachment.setBane(finalBane > 0);
        int finalBleed = bleed;
        attachment.setBleeding(finalBleed);
        player.setData(ForceAttachments.PLAYER_MOD, (Object)attachment);
    }

    @SubscribeEvent
    public void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        PlayerModifierAttachment attachment;
        Player player = event.getEntity();
        if (player.hasData(ForceAttachments.PLAYER_MOD) && (attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD)).hasFullSet() && player.getMainHandItem().isEmpty() && event.getTargetBlock().getBlock().getExplosionResistance() <= 2.0f) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        PlayerModifierAttachment attachment;
        Player player = event.getEntity();
        if (player.hasData(ForceAttachments.PLAYER_MOD) && (attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD)).hasFullSet() && player.getMainHandItem().isEmpty() && event.getOriginalSpeed() < 6.0f) {
            event.setNewSpeed(6.0f);
        }
    }
}

