/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.registry.ForceSounds;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FairyEntity
extends PathfinderMob
implements FlyingAnimal {
    public FairyEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new LookHelperController((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(8, (Goal)new WanderGoal());
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void playerTouch(Player playerEntity) {
        this.playSound(this.collideSound(playerEntity), 1.0f, 1.0f);
        playerEntity.heal(Float.MAX_VALUE);
        this.discard();
    }

    public static boolean canSpawnOn(EntityType<? extends Mob> typeIn, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.below();
        return reason == MobSpawnType.SPAWNER || level.getBlockState(blockpos).isValidSpawn((BlockGetter)level, blockpos, typeIn) && level.getRawBrightness(pos, 0) > 8;
    }

    public SoundEvent collideSound(Player playerEntity) {
        int randomInt = this.level().random.nextInt(100);
        if (UUID.fromString("7135da42-d327-47bb-bb04-5ba4e212fb32").equals(playerEntity.getUUID())) {
            return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
        }
        if (randomInt <= 1 && UUID.fromString("10755ea6-9721-467a-8b5c-92adf689072c").equals(playerEntity.getUUID())) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN_SPECIAL.get();
        }
        if (randomInt <= 10) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN.get();
        }
        return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
    }

    public void tick() {
        super.tick();
        if (this.random.nextFloat() < 0.05f && this.getDeltaMovement() != Vec3.ZERO) {
            for (int i = 0; i < this.random.nextInt(2) + 1; ++i) {
                this.addParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), (ParticleOptions)ParticleTypes.POOF);
            }
        }
    }

    private void addParticle(Level level, double posX, double posX2, double posZ, double posZ2, double posY, ParticleOptions particleData) {
        level.addParticle(particleData, Mth.lerp((double)level.random.nextDouble(), (double)posX, (double)posX2), posY - (double)0.2f, Mth.lerp((double)level.random.nextDouble(), (double)posZ, (double)posZ2), 0.0, 0.0, 0.0);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    static class LookHelperController
    extends LookControl {
        public LookHelperController(Mob entityIn) {
            super(entityIn);
        }

        public void tick() {
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return FairyEntity.this.navigation.isDone() && FairyEntity.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return FairyEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 randomLocation = this.getRandomLocation();
            if (randomLocation != null) {
                FairyEntity.this.navigation.moveTo(FairyEntity.this.navigation.createPath(BlockPos.containing((Position)randomLocation), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vector3d = FairyEntity.this.getViewVector(0.0f);
            Vec3 vector3d2 = HoverRandomPos.getPos((PathfinderMob)FairyEntity.this, (int)8, (int)7, (double)vector3d.x, (double)vector3d.z, (float)1.5707964f, (int)3, (int)1);
            return vector3d2 != null ? vector3d2 : AirAndWaterRandomPos.getPos((PathfinderMob)FairyEntity.this, (int)8, (int)4, (int)-2, (double)vector3d.x, (double)vector3d.z, (double)1.5707963705062866);
        }
    }
}

