/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class AngryEndermanEntity
extends EnderMan {
    public AngryEndermanEntity(EntityType<? extends EnderMan> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WATER, 8.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new StareGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((AngryEndermanEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive() && !this.isInWaterOrBubble()) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 64.0;
            double d1 = this.getY() + (double)(this.random.nextInt(64) - 32);
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    static class StareGoal
    extends Goal {
        private final EnderMan enderman;
        private LivingEntity targetPlayer;

        public StareGoal(EnderMan endermanIn) {
            this.enderman = endermanIn;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.targetPlayer = this.enderman.getTarget();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.distanceToSqr((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.isLookingAtMe((Player)this.targetPlayer);
        }

        public void start() {
            this.enderman.getNavigation().stop();
        }

        public void tick() {
            this.enderman.getLookControl().setLookAt(this.targetPlayer.getX(), this.targetPlayer.getEyeY(), this.targetPlayer.getZ());
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final AngryEndermanEntity enderman;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();

        public FindPlayerGoal(AngryEndermanEntity endermantIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)endermantIn, Player.class, 10, false, false, p_i241912_2_);
            this.enderman = endermantIn;
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(livingEntity -> endermantIn.isLookingAtMe((Player)livingEntity));
        }

        public boolean canUse() {
            this.player = this.enderman.level().getNearestPlayer(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void start() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void stop() {
            this.player = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.player != null) {
                if (!this.enderman.isLookingAtMe(this.player)) {
                    return false;
                }
                this.enderman.lookAt((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.target != null && this.continueAggroTargetConditions.test((LivingEntity)this.enderman, this.target) ? true : super.canContinueToUse();
        }

        public void tick() {
            if (this.enderman.getTarget() == null) {
                super.setTarget((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.target = this.player;
                    this.player = null;
                    super.start();
                }
            } else {
                if (this.target != null && !this.enderman.isPassenger()) {
                    if (this.enderman.isLookingAtMe((Player)this.target)) {
                        if (this.target.distanceToSqr((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.target.distanceToSqr((Entity)this.enderman) > 128.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.target)) {
                        this.teleportTime = 0;
                    }
                }
                super.tick();
            }
        }
    }
}

