/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.effects;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;

public class MagnetEffect
extends MobEffect {
    public MagnetEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public boolean isInstantenous() {
        return false;
    }

    public boolean isBeneficial() {
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        double x = entity.getX();
        double y = entity.getY() + 0.75;
        double z = entity.getZ();
        double range = 10.0;
        List items = entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(x - (range += (double)((float)amplifier * 0.3f)), y - range, z - range, x + range, y + range, z + range));
        for (ItemEntity item : items) {
            if (item.getItem().isEmpty() || !item.isAlive()) continue;
            float strength = 0.14f;
            Vec3 entityVector = new Vec3(item.getX(), item.getY() - item.getPassengerRidingPosition((Entity)entity).y() + (double)(item.getBbHeight() / 2.0f), item.getZ());
            Vec3 finalVector = new Vec3(x, y, z).subtract(entityVector);
            if (Math.sqrt(finalVector.x * finalVector.x + finalVector.y * finalVector.y + finalVector.z * finalVector.z) > 1.0) {
                finalVector = finalVector.normalize();
            }
            item.setDeltaMovement(finalVector.multiply((double)strength, (double)strength, (double)strength));
        }
        return true;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(this){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

