/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.tags;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ForceItemTagProvider
extends ItemTagsProvider {
    public static final TagKey<Item> ORES_IN_GROUND_DEEPSLATE = ForceItemTagProvider.commonTag("ores_in_ground/deepslate");
    public static final TagKey<Item> ORES_IN_GROUND_STONE = ForceItemTagProvider.commonTag("ores_in_ground/stone");
    public static final TagKey<Item> ORES = ForceItemTagProvider.commonTag("ores");
    public static final TagKey<Item> ORES_POWER = ForceItemTagProvider.commonTag("ores/power");
    public static final TagKey<Item> MEAT = ForceItemTagProvider.mcTag("meat");

    public ForceItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider.contentsGetter(), "forcecraft", existingFileHelper);
    }

    private static TagKey<Item> commonTag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<Item> mcTag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(ORES_IN_GROUND_DEEPSLATE).add((Object)((Item)ForceRegistry.DEEPSLATE_POWER_ORE_ITEM.get()));
        this.tag(ORES_IN_GROUND_STONE).add((Object)((Item)ForceRegistry.POWER_ORE_ITEM.get()));
        this.tag(ORES_POWER).add((Object[])new Item[]{(Item)ForceRegistry.POWER_ORE_ITEM.get(), (Item)ForceRegistry.DEEPSLATE_POWER_ORE_ITEM.get()});
        this.tag(ORES).addTag(ORES_POWER);
        this.tag(ForceTags.FORTUNE).add((Object[])new Item[]{(Item)ForceRegistry.FORTUNE.get(), (Item)ForceRegistry.FORTUNE_COOKIE.get()});
        this.tag(ForceTags.BACONATOR_FOOD).add((Object)((Item)ForceRegistry.COOKED_BACON.get()));
        this.tag(ForceTags.ENDER).add((Object[])new Item[]{Items.ENDER_EYE, Items.ENDER_PEARL});
        this.tag(ForceTags.CHU_JELLY).add((Object[])new Item[]{(Item)ForceRegistry.RED_CHU_JELLY.get(), (Item)ForceRegistry.GREEN_CHU_JELLY.get(), (Item)ForceRegistry.BLUE_CHU_JELLY.get(), (Item)ForceRegistry.GOLD_CHU_JELLY.get()});
        this.tag(ForceTags.ENTITY_FLASKS).add((Object[])new Item[]{(Item)ForceRegistry.ENTITY_FLASK.get(), (Item)ForceRegistry.BAT_FLASK.get(), (Item)ForceRegistry.BEE_FLASK.get(), (Item)ForceRegistry.CAT_FLASK.get(), (Item)ForceRegistry.CAVE_SPIDER_FLASK.get(), (Item)ForceRegistry.CHICKEN_FLASK.get(), (Item)ForceRegistry.COD_FLASK.get(), (Item)ForceRegistry.COW_FLASK.get(), (Item)ForceRegistry.DOLPHIN_FLASK.get(), (Item)ForceRegistry.DONKEY_FLASK.get(), (Item)ForceRegistry.ENDERMAN_FLASK.get(), (Item)ForceRegistry.FOX_FLASK.get(), (Item)ForceRegistry.HORSE_FLASK.get(), (Item)ForceRegistry.IRON_GOLEM_FLASK.get(), (Item)ForceRegistry.LLAMA_FLASK.get(), (Item)ForceRegistry.MOOSHROOM_FLASK.get(), (Item)ForceRegistry.MULE_FLASK.get(), (Item)ForceRegistry.PANDA_FLASK.get(), (Item)ForceRegistry.PARROT_FLASK.get(), (Item)ForceRegistry.PIG_FLASK.get(), (Item)ForceRegistry.PIGLIN_FLASK.get(), (Item)ForceRegistry.POLAR_BEAR_FLASK.get(), (Item)ForceRegistry.PUFFERFISH_FLASK.get(), (Item)ForceRegistry.RABBIT_FLASK.get(), (Item)ForceRegistry.SALMON_FLASK.get(), (Item)ForceRegistry.SHEEP_FLASK.get(), (Item)ForceRegistry.SKELETON_FLASK.get(), (Item)ForceRegistry.SNOW_GOLEM_FLASK.get(), (Item)ForceRegistry.SPIDER_FLASK.get(), (Item)ForceRegistry.SQUID_FLASK.get(), (Item)ForceRegistry.STRIDER_FLASK.get(), (Item)ForceRegistry.TROPICAL_FISH_FLASK.get(), (Item)ForceRegistry.TURTLE_FLASK.get(), (Item)ForceRegistry.VILLAGER_FLASK.get(), (Item)ForceRegistry.WANDERING_TRADER_FLASK.get(), (Item)ForceRegistry.WOLF_FLASK.get(), (Item)ForceRegistry.ZOMBIFIED_PIGLIN_FLASK.get()});
        this.tag(ForceTags.FORCE_FURNACES).add((Object[])new Item[]{ForceRegistry.FORCE_FURNACE.asItem(), ForceRegistry.BLACK_FORCE_FURNACE.asItem(), ForceRegistry.BLUE_FORCE_FURNACE.asItem(), ForceRegistry.BROWN_FORCE_FURNACE.asItem(), ForceRegistry.CYAN_FORCE_FURNACE.asItem(), ForceRegistry.GRAY_FORCE_FURNACE.asItem(), ForceRegistry.GREEN_FORCE_FURNACE.asItem(), ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.asItem(), ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.asItem(), ForceRegistry.LIME_FORCE_FURNACE.asItem(), ForceRegistry.MAGENTA_FORCE_FURNACE.asItem(), ForceRegistry.ORANGE_FORCE_FURNACE.asItem(), ForceRegistry.PINK_FORCE_FURNACE.asItem(), ForceRegistry.PURPLE_FORCE_FURNACE.asItem(), ForceRegistry.RED_FORCE_FURNACE.asItem(), ForceRegistry.WHITE_FORCE_FURNACE.asItem()});
        this.tag(ItemTags.MEAT).add((Object[])new Item[]{(Item)ForceRegistry.RAW_BACON.get(), (Item)ForceRegistry.COOKED_BACON.get()});
        this.tag(MEAT).add((Object[])new Item[]{(Item)ForceRegistry.RAW_BACON.get(), (Item)ForceRegistry.COOKED_BACON.get()});
        this.tag(ItemTags.FOOT_ARMOR).add((Object)((Item)ForceRegistry.FORCE_BOOTS.get()));
        this.tag(ItemTags.LEG_ARMOR).add((Object)((Item)ForceRegistry.FORCE_LEGS.get()));
        this.tag(ItemTags.CHEST_ARMOR).add((Object)((Item)ForceRegistry.FORCE_CHEST.get()));
        this.tag(ItemTags.HEAD_ARMOR).add((Object)((Item)ForceRegistry.FORCE_HELMET.get()));
        this.tag(ItemTags.PICKAXES).add((Object)((Item)ForceRegistry.FORCE_PICKAXE.get()));
        this.tag(ItemTags.SHOVELS).add((Object)((Item)ForceRegistry.FORCE_SHOVEL.get()));
        this.tag(ItemTags.AXES).add((Object)((Item)ForceRegistry.FORCE_AXE.get()));
        this.tag(Tags.Items.TOOLS_BOW).add((Object)((Item)ForceRegistry.FORCE_BOW.get()));
        this.tag(ItemTags.SWORDS).add((Object)((Item)ForceRegistry.FORCE_SWORD.get()));
        this.tag(Tags.Items.TOOLS_SHEAR).add((Object)((Item)ForceRegistry.FORCE_SHEARS.get()));
        this.tag(Tags.Items.DRINKS_MILK).add((Object)((Item)ForceRegistry.MILK_FORCE_FLASK.get()));
        this.tag(Tags.Items.DRINKS_MAGIC).add((Object)((Item)ForceRegistry.FORCE_FLASK.get()));
        this.tag(ItemTags.WOODEN_STAIRS).add((Object)ForceRegistry.FORCE_PLANK_STAIRS.asItem());
        this.tag(ItemTags.STAIRS).add((Object[])new Item[]{ForceRegistry.FORCE_BRICK_RED_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_YELLOW_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_GREEN_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_BLUE_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_WHITE_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_BLACK_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_BROWN_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_ORANGE_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_LIGHT_BLUE_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_MAGENTA_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_PINK_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_LIGHT_GRAY_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_LIME_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_CYAN_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_PURPLE_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_GRAY_STAIRS.asItem(), ForceRegistry.FORCE_BRICK_STAIRS.asItem()});
        this.tag(ItemTags.WOODEN_STAIRS).add((Object)ForceRegistry.FORCE_PLANK_STAIRS.asItem());
        this.tag(ItemTags.SLABS).add((Object[])new Item[]{ForceRegistry.FORCE_BRICK_RED_SLAB.asItem(), ForceRegistry.FORCE_BRICK_YELLOW_SLAB.asItem(), ForceRegistry.FORCE_BRICK_GREEN_SLAB.asItem(), ForceRegistry.FORCE_BRICK_BLUE_SLAB.asItem(), ForceRegistry.FORCE_BRICK_WHITE_SLAB.asItem(), ForceRegistry.FORCE_BRICK_BLACK_SLAB.asItem(), ForceRegistry.FORCE_BRICK_BROWN_SLAB.asItem(), ForceRegistry.FORCE_BRICK_ORANGE_SLAB.asItem(), ForceRegistry.FORCE_BRICK_LIGHT_BLUE_SLAB.asItem(), ForceRegistry.FORCE_BRICK_MAGENTA_SLAB.asItem(), ForceRegistry.FORCE_BRICK_PINK_SLAB.asItem(), ForceRegistry.FORCE_BRICK_LIGHT_GRAY_SLAB.asItem(), ForceRegistry.FORCE_BRICK_LIME_SLAB.asItem(), ForceRegistry.FORCE_BRICK_CYAN_SLAB.asItem(), ForceRegistry.FORCE_BRICK_PURPLE_SLAB.asItem(), ForceRegistry.FORCE_BRICK_GRAY_SLAB.asItem(), ForceRegistry.FORCE_BRICK_SLAB.asItem()});
        this.tag(ItemTags.LEAVES).add((Object)ForceRegistry.FORCE_LEAVES.asItem());
        this.tag(ItemTags.PLANKS).add((Object)ForceRegistry.FORCE_PLANKS.asItem());
        this.tag(ForceTags.FORCE_LOGS_ITEM).add((Object[])new Item[]{(Item)ForceRegistry.FORCE_LOG_ITEM.get(), (Item)ForceRegistry.FORCE_WOOD_ITEM.get()});
        this.tag(ItemTags.LOGS_THAT_BURN).addTag(ForceTags.FORCE_LOGS_ITEM);
        this.tag(ItemTags.SAPLINGS).add((Object)((Item)ForceRegistry.FORCE_SAPLING_ITEM.get()));
    }
}

