/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.recipe;

import com.mrbysco.forcecraft.recipe.TransmutationRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TransmutationRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    @Nullable
    private String group;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public TransmutationRecipeBuilder(ItemStack result) {
        this.result = result;
        this.requires((ItemLike)ForceRegistry.FORCE_ROD.get());
        this.unlockedBy("has_rod", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ForceRegistry.FORCE_ROD.get()}).build()))));
    }

    public static TransmutationRecipeBuilder transmutation(ItemLike resultItem) {
        return new TransmutationRecipeBuilder(new ItemStack(resultItem, 1));
    }

    public static TransmutationRecipeBuilder transmutation(ItemLike resultItem, int count) {
        return new TransmutationRecipeBuilder(new ItemStack(resultItem, count));
    }

    public static TransmutationRecipeBuilder transmutation(ItemStack result) {
        return new TransmutationRecipeBuilder(result);
    }

    public TransmutationRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.of(pTag));
    }

    public TransmutationRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public TransmutationRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.of((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public TransmutationRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public TransmutationRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.ingredients.add((Object)pIngredient);
        }
        return this;
    }

    public TransmutationRecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public TransmutationRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        Advancement.Builder advancement$builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        TransmutationRecipe recipe = new TransmutationRecipe(this.group == null ? "" : this.group, this.result, this.ingredients);
        output.accept(id, (Recipe)recipe, advancement$builder.build(id.withPrefix("recipes/transmutation/")));
    }
}

