/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.storage;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.storage.BeltStorage;
import com.mrbysco.forcecraft.components.storage.PackStorage;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class StorageManager {
    private static final BeltWSD blankBelts = new BeltWSD();
    private static final PackWSD blankPacks = new PackWSD();
    protected static BeltWSD cachedBelts;
    protected static PackWSD cachedPacks;

    public static boolean isServer() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }

    public static BeltWSD getBelts() {
        if (StorageManager.isServer()) {
            if (cachedBelts == null) {
                cachedBelts = (BeltWSD)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(BeltWSD::new, BeltWSD::load), "forcecraft_belts");
            }
            return cachedBelts;
        }
        return blankBelts;
    }

    public static PackWSD getPacks() {
        if (StorageManager.isServer()) {
            if (cachedPacks == null) {
                cachedPacks = (PackWSD)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(PackWSD::new, PackWSD::load), "forcecraft_packs");
            }
            return cachedPacks;
        }
        return blankPacks;
    }

    public static BeltStorage getOrCreateBelt(ItemStack stack) {
        UUID uuid;
        BeltWSD data = StorageManager.getBelts();
        if (!stack.has(ForceComponents.UUID)) {
            uuid = UUID.randomUUID();
            stack.set(ForceComponents.UUID, (Object)uuid);
        } else {
            uuid = (UUID)stack.get(ForceComponents.UUID);
        }
        return data.getOrCreate(uuid);
    }

    public static Optional<BeltStorage> getBelt(ItemStack stack) {
        UUID uuid;
        BeltWSD data;
        if (stack.has(ForceComponents.UUID) && (data = StorageManager.getBelts()).contains(uuid = (UUID)stack.get(ForceComponents.UUID))) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<BeltStorage> getBelt(UUID uuid) {
        BeltWSD data = StorageManager.getBelts();
        if (data.contains(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static PackStorage getOrCreatePack(ItemStack stack) {
        UUID uuid;
        PackWSD data = StorageManager.getPacks();
        if (!stack.has(ForceComponents.UUID)) {
            uuid = UUID.randomUUID();
            stack.set(ForceComponents.UUID, (Object)uuid);
        } else {
            uuid = (UUID)stack.get(ForceComponents.UUID);
        }
        return data.getOrCreate(uuid);
    }

    public static Optional<PackStorage> getPack(ItemStack stack) {
        UUID uuid;
        PackWSD data;
        if (stack.has(ForceComponents.UUID) && (data = StorageManager.getPacks()).contains(uuid = (UUID)stack.get(ForceComponents.UUID))) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<PackStorage> getPack(UUID uuid) {
        PackWSD data = StorageManager.getPacks();
        if (data.contains(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<UUID> getUUID(ItemStack stack) {
        if (stack.has(ForceComponents.UUID)) {
            return Optional.of((UUID)stack.get(ForceComponents.UUID));
        }
        return Optional.empty();
    }

    public static IItemHandler getCapability(ItemStack stack) {
        if (StorageManager.isServer() && stack.has(ForceComponents.UUID)) {
            UUID uuid = (UUID)stack.get(ForceComponents.UUID);
            if (stack.getItem() instanceof ForceBeltItem) {
                return StorageManager.getBelt(uuid).map(BeltStorage::getInventory).orElse(null);
            }
            if (stack.getItem() instanceof ForcePackItem) {
                return StorageManager.getPack(uuid).map(PackStorage::getInventory).orElse(null);
            }
        }
        return null;
    }

    protected static class BeltWSD
    extends SavedData {
        public static final String NAME = "forcecraft_belts";
        protected final HashMap<UUID, BeltStorage> BELTS = new HashMap();

        protected BeltWSD() {
        }

        public HashMap<UUID, BeltStorage> get() {
            return this.BELTS;
        }

        public boolean contains(UUID uuid) {
            return this.BELTS.containsKey(uuid);
        }

        public BeltStorage get(UUID uuid) {
            return this.BELTS.get(uuid);
        }

        public BeltStorage getOrCreate(UUID uuid) {
            return this.BELTS.computeIfAbsent(uuid, id -> {
                this.setDirty();
                return new BeltStorage(uuid);
            });
        }

        public static BeltWSD load(CompoundTag tag, HolderLookup.Provider provider) {
            BeltWSD data = new BeltWSD();
            if (tag.contains("belts")) {
                ListTag list = tag.getList("belts", 10);
                list.forEach(invNBT -> data.BELTS.put(((CompoundTag)invNBT).getUUID("uuid"), new BeltStorage((CompoundTag)invNBT, provider)));
            }
            return data;
        }

        @NotNull
        public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
            ListTag belts = new ListTag();
            this.BELTS.forEach((uuid, data) -> belts.add((Object)data.toNBT(provider)));
            compound.put("belts", (Tag)belts);
            return compound;
        }
    }

    public static class PackWSD
    extends SavedData {
        public static final String NAME = "forcecraft_packs";
        protected final HashMap<UUID, PackStorage> PACKS = new HashMap();

        public HashMap<UUID, PackStorage> get() {
            return this.PACKS;
        }

        public boolean contains(UUID uuid) {
            return this.PACKS.containsKey(uuid);
        }

        public PackStorage get(UUID uuid) {
            return this.PACKS.get(uuid);
        }

        public PackStorage getOrCreate(UUID uuid) {
            return this.PACKS.computeIfAbsent(uuid, id -> {
                this.setDirty();
                return new PackStorage(uuid);
            });
        }

        public static PackWSD load(CompoundTag tag, HolderLookup.Provider provider) {
            PackWSD data = new PackWSD();
            if (tag.contains("packs")) {
                ListTag list = tag.getList("packs", 10);
                list.forEach(invNBT -> data.PACKS.put(((CompoundTag)invNBT).getUUID("uuid"), new PackStorage((CompoundTag)invNBT, provider)));
            }
            return data;
        }

        @NotNull
        public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
            ListTag packs = new ListTag();
            this.PACKS.forEach((uuid, data) -> packs.add((Object)data.toNBT(provider)));
            compound.put("packs", (Tag)packs);
            return compound;
        }
    }
}

