/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.storage;

import com.mrbysco.forcecraft.components.storage.BeltStackHandler;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.items.IItemHandler;

public class BeltStorage {
    private final UUID uuid;
    private final BeltStackHandler inventory;

    public BeltStorage(UUID uuidIn) {
        this.uuid = uuidIn;
        this.inventory = new BeltStackHandler();
    }

    public BeltStorage(CompoundTag tag, HolderLookup.Provider registries) {
        this.uuid = tag.getUUID("uuid");
        this.inventory = new BeltStackHandler();
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public CompoundTag toNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("uuid", this.uuid);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        return tag;
    }
}

