/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.flask;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record FlaskContent(ResourceLocation storedType, CompoundTag entityData) {
    public static final Codec<FlaskContent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("storedType").forGetter(FlaskContent::storedType), (App)CompoundTag.CODEC.optionalFieldOf("entityData", (Object)new CompoundTag()).forGetter(FlaskContent::entityData)).apply((Applicative)inst, FlaskContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlaskContent> STREAM_CODEC = StreamCodec.of(FlaskContent::toNetwork, FlaskContent::fromNetwork);

    private static FlaskContent fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        ResourceLocation storedType = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)byteBuf);
        CompoundTag storedBlockNBT = byteBuf.readNbt();
        return new FlaskContent(storedType, storedBlockNBT);
    }

    private static void toNetwork(RegistryFriendlyByteBuf byteBuf, FlaskContent playerCompassData) {
        ResourceLocation.STREAM_CODEC.encode((Object)byteBuf, (Object)playerCompassData.storedType());
        byteBuf.writeNbt((Tag)playerCompassData.entityData());
    }
}

