/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.widgets;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemButton
extends Button {
    protected final ItemStack buttonStack;

    public ItemButton(int x, int y, int width, int height, Component title, ItemStack stack, Button.OnPress pressedAction, Button.CreateNarration createNarration) {
        super(x, y, width, height, title, pressedAction, createNarration);
        this.buttonStack = stack;
    }

    protected ItemButton(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.stack, builder.onPress, builder.createNarration);
        this.setTooltip(builder.tooltip);
    }

    public ItemStack getButtonStack() {
        return this.buttonStack;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.renderItemDecorations(minecraft.font, this.buttonStack, this.getX(), this.getY());
    }

    public static Builder builder(Component component, ItemStack stack, Button.OnPress onPress) {
        return new Builder(component, stack, onPress);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder {
        private final Component message;
        private final ItemStack stack;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = ItemButton.access$000();

        public Builder(Component component, ItemStack stack, Button.OnPress onPress) {
            this.message = component;
            this.stack = stack;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public ItemButton build() {
            return this.build(ItemButton::new);
        }

        public ItemButton build(Function<Builder, ItemButton> builder) {
            return builder.apply(this);
        }
    }
}

