/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.engine;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.blockentities.ForceEngineBlockEntity;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.menu.engine.ForceEngineMenu;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;

public class ForceEngineScreen
extends AbstractContainerScreen<ForceEngineMenu> {
    private final ResourceLocation TEXTURE = Reference.modLoc("textures/gui/container/force_engine.png");

    public ForceEngineScreen(ForceEngineMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.blit(this.TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.drawFuelTank(guiGraphics);
        this.drawThrottleTank(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<Object> text;
        int actualMouseX = mouseX - (this.width - this.imageWidth) / 2;
        int actualMouseY = mouseY - (this.height - this.imageHeight) / 2;
        ForceEngineBlockEntity tile = ((ForceEngineMenu)this.getMenu()).getTile();
        if (this.isHovering(66, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList<Object>();
            if (tile.getFuelFluid() == null) {
                text.add(Component.translatable((String)"gui.forcecraft.force_engine.empty"));
            } else if (tile.getFuelFluidStack() != null) {
                text.add(tile.getFuelFluidStack().getHoverName());
                text.add(Component.literal((String)(tile.getFuelAmount() + " mb")).withStyle(ChatFormatting.GOLD));
            }
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
        if (this.isHovering(94, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getThrottleFluid() == null) {
                text.add(Component.translatable((String)"gui.forcecraft.force_engine.empty"));
            } else if (tile.getThrottleFluidStack() != null) {
                text.add(tile.getThrottleFluidStack().getHoverName());
                text.add(Component.literal((String)(tile.getThrottleAmount() + " mb")).withStyle(ChatFormatting.GOLD));
            }
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
    }

    private void drawFuelTank(GuiGraphics guiGraphics) {
        if (((ForceEngineMenu)this.menu).getTile() == null || ((ForceEngineMenu)this.menu).getTile().getFuelFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineMenu)this.menu).getTile().getFuelFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineMenu)this.getMenu()).getTile().getFuelAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.leftPos + 66, this.topPos + 11, tankPercentage, 58);
        guiGraphics.blit(this.TEXTURE, this.leftPos + 66, this.topPos + 11, 176, 0, 16, 64);
    }

    private void drawThrottleTank(GuiGraphics guiGraphics) {
        if (((ForceEngineMenu)this.menu).getTile() == null || ((ForceEngineMenu)this.menu).getTile().getThrottleFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineMenu)this.menu).getTile().getThrottleFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineMenu)this.getMenu()).getTile().getThrottleAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.leftPos + 94, this.topPos + 11, tankPercentage, 58);
        guiGraphics.blit(this.TEXTURE, this.leftPos + 94, this.topPos + 11, 176, 0, 16, 64);
    }
}

