/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capability;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemStackHandlerWrapper
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final ItemStackHandler input;
    protected final ItemStackHandler output;

    public ItemStackHandlerWrapper(ItemStackHandler input, ItemStackHandler output) {
        this.input = input;
        this.output = output;
    }

    protected <T> T withHandler(int externalSlot, HandlerCallback<T> callback) {
        int numInputSlots = this.input.getSlots();
        boolean isInput = externalSlot < numInputSlots;
        int internalSlot = isInput ? externalSlot : externalSlot - numInputSlots;
        ItemStackHandler handler = isInput ? this.input : this.output;
        return callback.apply(handler, internalSlot, isInput);
    }

    protected void withHandlerV(int slot, HandlerCallbackVoid func) {
        this.withHandler(slot, (h, s, isInput) -> {
            func.apply(h, s, isInput);
            return false;
        });
    }

    public int getSlots() {
        return this.input.getSlots() + this.output.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getStackInSlot(s));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? h.insertItem(s, stack, simulate) : stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? ItemStack.EMPTY : h.extractItem(s, amount, simulate));
    }

    public int getSlotLimit(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getSlotLimit(s));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.withHandler(slot, (h, s, isInput) -> isInput && h.isItemValid(s, stack));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.withHandlerV(slot, (h, s, isInput) -> h.setStackInSlot(s, stack));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put(NBT_INPUT, (Tag)this.input.serializeNBT(registries));
        tag.put(NBT_OUTPUT, (Tag)this.output.serializeNBT(registries));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        this.input.deserializeNBT(registries, tag.getCompound(NBT_INPUT));
        this.output.deserializeNBT(registries, tag.getCompound(NBT_OUTPUT));
    }

    @FunctionalInterface
    protected static interface HandlerCallback<T> {
        public T apply(ItemStackHandler var1, int var2, boolean var3);
    }

    @FunctionalInterface
    protected static interface HandlerCallbackVoid {
        public void apply(ItemStackHandler var1, int var2, boolean var3);
    }
}

