/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.torch;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.TimeTorchBlockEntity;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TimeTorchBlock
extends TorchBlock
implements EntityBlock {
    public TimeTorchBlock(BlockBehaviour.Properties properties, SimpleParticleType particleData) {
        super(particleData, properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)ConfigHandler.COMMON.timeTorchEnabled.get() != false ? new TimeTorchBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TimeTorchBlock.createTimeTorchTicker(level, blockEntityType, ForceRegistry.TIME_TORCH_BLOCK_ENTITY.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTimeTorchTicker(Level level, BlockEntityType<T> entityType, BlockEntityType<? extends TimeTorchBlockEntity> timeTorchBlockEntityType) {
        return level.isClientSide ? null : TimeTorchBlock.createTickerHelper(entityType, timeTorchBlockEntityType, TimeTorchBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> entityType, BlockEntityTicker<? super E> entityTicker) {
        return entityType == blockEntityType ? entityTicker : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (((Boolean)ConfigHandler.COMMON.timeTorchLogging.get()).booleanValue()) {
            if (placer != null) {
                ForceCraft.LOGGER.info("A Time Torch has been placed at {} by {}", (Object)pos, (Object)placer.getDisplayName().getString());
            } else {
                ForceCraft.LOGGER.info("A Time Torch has been placed at {} by a non entity", (Object)pos);
            }
        }
    }
}

