/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities.furnace;

import com.google.common.collect.Lists;
import com.mrbysco.forcecraft.blockentities.furnace.BiggestInventory;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForceFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int INPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int UPGRADE_SLOT = 0;
    protected static final int[] SLOTS_UP = new int[]{0};
    protected static final int[] SLOTS_DOWN = new int[]{2, 1};
    protected static final int[] SLOTS_HORIZONTAL = new int[]{1};
    public final ItemStackHandler handler = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 1) {
                ItemStack itemstack = this.getStackInSlot(1);
                return AbstractForceFurnaceBlockEntity.isFuel(stack) || stack.getItem() == Items.BUCKET && itemstack.getItem() != Items.BUCKET;
            }
            return slot != 2;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            if (slot == 0) {
                AbstractForceFurnaceBlockEntity.this.setChanged();
            }
        }
    };
    public final ItemStackHandler upgradeHandler = new ItemStackHandler(this, 1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.getStackInSlot(slot).isEmpty() && stack.getItem() instanceof UpgradeCoreItem && stack.getCount() == 1;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }
    };
    protected static final List<ResourceLocation> hopperBlacklist = List.of(ResourceLocation.withDefaultNamespace((String)"hopper"), ResourceLocation.fromNamespaceAndPath((String)"cyclic", (String)"hopper"), ResourceLocation.fromNamespaceAndPath((String)"cyclic", (String)"hopper_gold"), ResourceLocation.fromNamespaceAndPath((String)"cyclic", (String)"hopper_fluid"), ResourceLocation.fromNamespaceAndPath((String)"uppers", (String)"upper"), ResourceLocation.fromNamespaceAndPath((String)"goldenhopper", (String)"golden_hopper"), ResourceLocation.fromNamespaceAndPath((String)"woodenhopper", (String)"wooden_hopper"));
    protected int litTime;
    protected int litDuration;
    protected int cookingProgress;
    protected int cookingTotalTime;
    protected int burnSpeed;
    protected int cookingSpeed;
    protected final ContainerData furnaceData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> AbstractForceFurnaceBlockEntity.this.litTime;
                case 1 -> AbstractForceFurnaceBlockEntity.this.litDuration;
                case 2 -> AbstractForceFurnaceBlockEntity.this.cookingProgress;
                case 3 -> AbstractForceFurnaceBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractForceFurnaceBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    AbstractForceFurnaceBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    AbstractForceFurnaceBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    AbstractForceFurnaceBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    protected RecipeHolder<? extends AbstractCookingRecipe> currentRecipe;
    protected ItemStack failedMatch = ItemStack.EMPTY;
    protected final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();

    protected AbstractForceFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        ItemStack upgrade = this.getUpgrade();
        if (!upgrade.isEmpty()) {
            if (upgrade.getItem() == ForceRegistry.FREEZING_CORE.get()) {
                return ForceRecipes.FREEZING.get();
            }
            if (upgrade.getItem() == ForceRegistry.GRINDING_CORE.get()) {
                return ForceRecipes.GRINDING.get();
            }
        }
        return RecipeType.SMELTING;
    }

    public void setUpgrade(ItemStack upgrade) {
        this.upgradeHandler.setStackInSlot(0, upgrade);
    }

    public ItemStack getUpgrade() {
        return this.upgradeHandler.getStackInSlot(0);
    }

    public boolean isEfficient() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().isEmpty() && upgrade.getItem() == ForceRegistry.HEAT_CORE.get();
    }

    public boolean isFast() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().isEmpty() && upgrade.getItem() == ForceRegistry.SPEED_CORE.get();
    }

    public boolean hasXPMultiplied() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().isEmpty() && upgrade.getItem() == ForceRegistry.EXPERIENCE_CORE.get();
    }

    public int getSpeed() {
        return this.isFast() ? 10 : 2;
    }

    public int getXPMultiplier() {
        return this.hasXPMultiplied() ? 2 : 1;
    }

    protected RecipeHolder<? extends AbstractCookingRecipe> getRecipe() {
        ItemStack input = this.getItem(0);
        if (input.isEmpty() || input == this.failedMatch || this.level == null) {
            return null;
        }
        if (this.currentRecipe != null && ((AbstractCookingRecipe)this.currentRecipe.value()).matches(new SingleRecipeInput(this.handler.getStackInSlot(0)), this.level) && ((AbstractCookingRecipe)this.currentRecipe.value()).getType() == this.getRecipeType()) {
            return this.currentRecipe;
        }
        RecipeHolder rec = this.level.getRecipeManager().getRecipeFor(this.getRecipeType(), (RecipeInput)new SingleRecipeInput(this.handler.getStackInSlot(0)), this.level).orElse(null);
        this.failedMatch = rec == null ? input : ItemStack.EMPTY;
        this.currentRecipe = rec;
        return this.currentRecipe;
    }

    protected boolean isLit() {
        return this.litTime > 0;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.upgradeHandler.deserializeNBT(registries, tag.getCompound("UpgradeHandler"));
        this.handler.deserializeNBT(registries, tag.getCompound("ItemStackHandler"));
        this.litTime = tag.getInt("BurnTime");
        this.burnSpeed = tag.getInt("BurnSpeed");
        this.cookingProgress = tag.getInt("CookTime");
        this.cookingTotalTime = tag.getInt("CookTimeTotal");
        this.litDuration = tag.contains("BurnTimeTotal") ? tag.getInt("BurnTimeTotal") : this.getBurnDuration(this.handler.getStackInSlot(1));
        this.cookingSpeed = tag.getInt("CookSpeed");
        CompoundTag recipesUsed = tag.getCompound("RecipesUsed");
        for (String s : recipesUsed.getAllKeys()) {
            this.recipes.put((Object)ResourceLocation.parse((String)s), recipesUsed.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("BurnTime", this.litTime);
        compound.putInt("BurnSpeed", this.burnSpeed);
        compound.putInt("CookTime", this.cookingProgress);
        compound.putInt("CookTimeTotal", this.cookingTotalTime);
        compound.putInt("BurnTimeTotal", this.litDuration);
        compound.putInt("CookSpeed", this.cookingSpeed);
        compound.put("UpgradeHandler", (Tag)this.upgradeHandler.serializeNBT(registries));
        compound.put("ItemStackHandler", (Tag)this.handler.serializeNBT(registries));
        CompoundTag recipesUsed = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> recipesUsed.putInt(recipeId.toString(), craftedAmount.intValue()));
        compound.put("RecipesUsed", (Tag)recipesUsed);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractForceFurnaceBlockEntity furnace) {
        boolean wasBurning = furnace.isLit();
        if (furnace.isLit() && furnace.canBurn(furnace.currentRecipe)) {
            int speed = furnace.getSpeed();
            if (furnace.burnSpeed != speed) {
                furnace.burnSpeed = speed;
            }
            furnace.litTime -= furnace.burnSpeed;
        }
        if (level != null) {
            boolean dirty = false;
            ItemStack fuel = furnace.handler.getStackInSlot(1);
            if (furnace.isLit() || !fuel.isEmpty() && !furnace.handler.getStackInSlot(0).isEmpty()) {
                AbstractCookingRecipe cookingRecipe;
                RecipeHolder<? extends AbstractCookingRecipe> recipeHolder = furnace.getRecipe();
                AbstractCookingRecipe abstractCookingRecipe = cookingRecipe = recipeHolder != null ? (AbstractCookingRecipe)recipeHolder.value() : null;
                if (!furnace.isLit() && furnace.canBurn(recipeHolder)) {
                    furnace.litDuration = furnace.litTime = furnace.getBurnDuration(fuel);
                    if (furnace.isLit()) {
                        dirty = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            furnace.handler.setStackInSlot(1, fuel.getCraftingRemainingItem());
                        } else if (!fuel.isEmpty()) {
                            fuel.shrink(1);
                            if (fuel.isEmpty()) {
                                furnace.handler.setStackInSlot(1, fuel.getCraftingRemainingItem());
                            }
                        }
                    }
                }
                if (furnace.isLit() && furnace.canBurn(recipeHolder)) {
                    int speed;
                    int n = speed = furnace.isEfficient() ? 4 : furnace.getSpeed();
                    if (furnace.cookingSpeed != speed) {
                        furnace.cookingSpeed = speed;
                    }
                    if (cookingRecipe != null && furnace.cookingTotalTime != cookingRecipe.getCookingTime()) {
                        furnace.cookingTotalTime = cookingRecipe.getCookingTime();
                    }
                    furnace.cookingProgress += furnace.cookingSpeed;
                    if (furnace.cookingProgress >= furnace.cookingTotalTime) {
                        furnace.cookingProgress = 0;
                        furnace.cookingTotalTime = furnace.getCookingProgress();
                        if (furnace.burn(recipeHolder)) {
                            furnace.setRecipeUsed(recipeHolder);
                        }
                        dirty = true;
                    }
                } else {
                    furnace.cookingProgress = 0;
                }
            } else if (!furnace.isLit() && furnace.cookingProgress > 0) {
                furnace.cookingProgress = Mth.clamp((int)(furnace.cookingProgress - 2), (int)0, (int)furnace.cookingTotalTime);
            }
            if (wasBurning != furnace.isLit()) {
                dirty = true;
                level.setBlock(pos, (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(furnace.isLit())), 3);
            }
            if (dirty) {
                AbstractForceFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    protected boolean canBurn(@Nullable RecipeHolder<?> recipeHolder) {
        Recipe recipeIn;
        Recipe recipe = recipeIn = recipeHolder != null ? recipeHolder.value() : null;
        if (!this.handler.getStackInSlot(0).isEmpty() && recipeIn != null) {
            ItemStack recipeOutput = recipeIn.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            if (recipeOutput.isEmpty()) {
                return false;
            }
            ItemStack output = this.handler.getStackInSlot(2);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            if (output.getCount() + recipeOutput.getCount() <= this.getMaxStackSize() && output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize()) {
                return true;
            }
            return output.getCount() + recipeOutput.getCount() <= recipeOutput.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(@Nullable RecipeHolder<?> holder) {
        if (holder != null && this.canBurn(holder) && this.level != null) {
            Recipe recipe = holder.value();
            ItemStack itemstack = this.handler.getStackInSlot(0);
            List additionalBlacklist = new ArrayList();
            ConfigHandler.COMMON.furnaceOutputBlacklist.get();
            if (!((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).isEmpty() && !((String)((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).getFirst()).isEmpty()) {
                additionalBlacklist = (List)ConfigHandler.COMMON.furnaceOutputBlacklist.get();
            }
            if (recipe instanceof MultipleOutputFurnaceRecipe) {
                MultipleOutputFurnaceRecipe multipleRecipe = (MultipleOutputFurnaceRecipe)recipe;
                NonNullList<ItemStack> outputStacks = multipleRecipe.getRecipeOutputs();
                for (int i = 0; i < outputStacks.size(); ++i) {
                    ItemStack outputStack = ((ItemStack)outputStacks.get(i)).copy();
                    if (i <= 0 || multipleRecipe.getSecondaryChance() == 1.0f && !(this.level.random.nextFloat() > multipleRecipe.getSecondaryChance())) {
                        BiggestInventory inventory;
                        IItemHandler itemHandler;
                        ArrayList<BiggestInventory> inventoryList2 = new ArrayList<BiggestInventory>();
                        for (Direction dir : Direction.values()) {
                            boolean flag2;
                            BlockPos offPos = this.worldPosition.relative(dir);
                            if (!this.level.isAreaLoaded(this.worldPosition, 1)) continue;
                            BlockEntity foundTile = this.level.getBlockEntity(offPos);
                            IItemHandler itemHandler2 = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offPos, (Object)dir.getOpposite());
                            if (foundTile == null || itemHandler2 == null) continue;
                            ResourceLocation typeLocation = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)foundTile.getType());
                            boolean flag = foundTile instanceof Hopper || foundTile instanceof AbstractFurnaceBlockEntity || foundTile instanceof AbstractForceFurnaceBlockEntity;
                            boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                            if (flag || !flag2 || foundTile.isRemoved() || !foundTile.hasLevel() || itemHandler2 == null) continue;
                            inventoryList2.add(new BiggestInventory(offPos, itemHandler2.getSlots(), dir.getOpposite()));
                        }
                        inventoryList2.sort(Collections.reverseOrder());
                        Iterator iterator = inventoryList2.iterator();
                        while (iterator.hasNext() && !(outputStack = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)iterator.next()).getIItemHandler(this.level, this.worldPosition)), (ItemStack)outputStack, (boolean)false)).isEmpty()) {
                        }
                        if (i > 0 && !outputStack.isEmpty()) {
                            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ(), outputStack);
                            this.level.addFreshEntity((Entity)itemEntity);
                            continue;
                        }
                        ItemStack currentOutputStack = this.handler.getStackInSlot(2);
                        if (currentOutputStack.isEmpty() && !outputStack.isEmpty()) {
                            this.handler.setStackInSlot(2, outputStack);
                            continue;
                        }
                        if (currentOutputStack.getItem() != ((ItemStack)outputStacks.get(i)).getItem()) continue;
                        currentOutputStack.grow(outputStack.getCount());
                        continue;
                    }
                    break;
                }
            } else {
                BiggestInventory inventory;
                IItemHandler itemHandler;
                ItemStack itemstack1 = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
                ItemStack outputStack = itemstack1.copy();
                ArrayList<BiggestInventory> inventoryList = new ArrayList<BiggestInventory>();
                for (Direction dir : Direction.values()) {
                    boolean flag2;
                    BlockPos offPos = this.worldPosition.relative(dir);
                    if (!this.level.isAreaLoaded(this.worldPosition, 1)) continue;
                    BlockEntity foundTile = this.level.getBlockEntity(offPos);
                    IItemHandler itemHandler3 = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offPos, (Object)dir.getOpposite());
                    if (foundTile == null || itemHandler3 == null) continue;
                    ResourceLocation typeLocation = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)foundTile.getType());
                    boolean flag = foundTile instanceof Hopper || foundTile instanceof AbstractFurnaceBlockEntity || foundTile instanceof AbstractForceFurnaceBlockEntity;
                    boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                    if (flag || !flag2 || foundTile.isRemoved() || !foundTile.hasLevel() || foundTile == null) continue;
                    inventoryList.add(new BiggestInventory(offPos, itemHandler3.getSlots(), dir.getOpposite()));
                }
                inventoryList.sort(Collections.reverseOrder());
                Iterator inventoryList2 = inventoryList.iterator();
                while (inventoryList2.hasNext() && !(outputStack = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)inventoryList2.next()).getIItemHandler(this.level, this.worldPosition)), (ItemStack)outputStack, (boolean)false)).isEmpty()) {
                }
                ItemStack itemstack2 = this.handler.getStackInSlot(2);
                if (itemstack2.isEmpty() && !outputStack.isEmpty()) {
                    this.handler.setStackInSlot(2, outputStack);
                } else if (itemstack2.getItem() == itemstack1.getItem()) {
                    itemstack2.grow(outputStack.getCount());
                }
            }
            if (!this.level.isClientSide) {
                this.setRecipeUsed(holder);
            }
            if (itemstack.getItem() == Blocks.WET_SPONGE.asItem() && !this.handler.getStackInSlot(1).isEmpty() && this.handler.getStackInSlot(1).getItem() == Items.BUCKET) {
                this.handler.setStackInSlot(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return fuel.getBurnTime(null);
    }

    protected int getCookingProgress() {
        if (this.level == null) {
            return 200;
        }
        RecipeHolder<? extends AbstractCookingRecipe> rec = this.getRecipe();
        if (rec == null) {
            return this.level.getRecipeManager().getRecipeFor(this.getRecipeType(), (RecipeInput)new SingleRecipeInput(this.handler.getStackInSlot(0)), this.level).map(RecipeHolder::value).map(AbstractCookingRecipe::getCookingTime).orElse(100);
        }
        return ((AbstractCookingRecipe)rec.value()).getCookingTime();
    }

    public static boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(null) > 0;
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.getItem();
            return item == Items.WATER_BUCKET || item == Items.BUCKET;
        }
        return true;
    }

    public int getContainerSize() {
        return this.handler.getSlots();
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList stacks = NonNullList.withSize((int)this.handler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            stacks.set(i, (Object)this.handler.getStackInSlot(i));
        }
        return stacks;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, (ItemStack)items.get(i));
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return this.handler.getStackInSlot(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ItemHandlerUtils.getAndSplit((IItemHandler)this.handler, index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ItemHandlerUtils.getAndRemove((IItemHandler)this.handler, index);
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack itemstack = this.handler.getStackInSlot(index);
        boolean flag = this.handler.isItemValid(index, stack) && !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack);
        this.handler.setStackInSlot(index, stack);
        if (stack.getCount() > this.handler.getSlotLimit(index)) {
            stack.setCount(this.handler.getSlotLimit(index));
        }
        if (index == 0 && !flag) {
            this.cookingTotalTime = this.getCookingProgress();
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.handler.isItemValid(index, stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.id();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        this.recipes.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel serverLevel, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            serverLevel.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractForceFurnaceBlockEntity.createExperience(serverLevel, pos, entry.getIntValue(), ((AbstractCookingRecipe)recipe.value()).getExperience() * (float)this.getXPMultiplier());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel serverLevel, Vec3 pos, int craftedAmount, float experience) {
        int i = Mth.floor((float)((float)craftedAmount * experience));
        float f = Mth.frac((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)pos, (int)i);
    }

    public void fillStackedContents(StackedContents helper) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            helper.accountStack(this.handler.getStackInSlot(i));
        }
    }

    public ContainerData getFurnaceData() {
        return this.furnaceData;
    }
}

