/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.blocks.engine.ForceEngineBlock;
import com.mrbysco.forcecraft.capability.FluidHandlerWrapper;
import com.mrbysco.forcecraft.capability.ItemStackHandlerWrapper;
import com.mrbysco.forcecraft.menu.engine.ForceEngineMenu;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceEngineBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int MAX_FLUID = 10000;
    protected FluidTank tankFuel = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineBlockEntity.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid().getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineBlockEntity.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.is(ForceTags.FORCE) || fluid.is(FluidTags.LAVA) || fluid.is(ForceTags.FUEL) || fluid.is(ForceTags.BIOFUEL);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.is(ForceTags.FORCE) || fluid.is(FluidTags.LAVA) || fluid.is(ForceTags.FUEL) || fluid.is(ForceTags.BIOFUEL);
        }
    };
    protected FluidTank tankThrottle = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineBlockEntity.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid().getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineBlockEntity.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.isSame((Fluid)Fluids.WATER) || fluid.is(ForceTags.MILK);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.isSame((Fluid)Fluids.WATER) || fluid.is(ForceTags.MILK);
        }
    };
    private final FluidHandlerWrapper tankWrapper = new FluidHandlerWrapper(this.tankThrottle, this.tankFuel);
    public final ItemStackHandler inputHandler = new ItemStackHandler(this, 2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null && stack.getMaxStackSize() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            IFluidHandler fluidCap = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (slot == 0) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.is(ForceTags.FORCE) || fluid.is(FluidTags.LAVA) || fluid.is(ForceTags.FUEL) || fluid.is(ForceTags.BIOFUEL);
                }
                return stack.is(ForceTags.FORCE_GEM) || stack.is(Tags.Items.NETHER_STARS) || fluidCap != null && fluidCap.getFluidInTank(0).getFluid().is(ForceTags.FORCE);
            }
            if (slot == 1) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.isSame((Fluid)Fluids.WATER) || fluid.is(ForceTags.MILK);
                }
                return false;
            }
            return false;
        }
    };
    public final ItemStackHandler outputHandler = new ItemStackHandler(this, 2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null && stack.getMaxStackSize() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };
    private final ItemStackHandlerWrapper stackWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outputHandler);
    private static final int FLUID_PER_GEM = 500;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public int throttleTime = 0;
    public int maxThrottleTime = 10;
    private Fluid cachedFuel;
    private Fluid cachedThrottle;
    public float generating = 0.0f;

    public ForceEngineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public ForceEngineBlockEntity(BlockPos pos, BlockState state) {
        this(ForceRegistry.FORCE_ENGINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.processTime = tag.getInt("processTime");
        this.maxProcessTime = tag.getInt("maxProcessTime");
        this.throttleTime = tag.getInt("throttleTime");
        this.maxThrottleTime = tag.getInt("maxThrottleTime");
        this.generating = tag.getFloat("generating");
        this.stackWrapper.deserializeNBT(registries, tag.getCompound("stackHandler"));
        this.tankWrapper.deserializeNBT(registries, tag.getCompound("fluid"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("processTime", this.processTime);
        compound.putInt("maxProcessTime", this.maxProcessTime);
        compound.putInt("throttleTime", this.throttleTime);
        compound.putInt("maxThrottleTime", this.maxThrottleTime);
        compound.putFloat("generating", this.generating);
        compound.put("stackHandler", (Tag)this.stackWrapper.serializeNBT(registries));
        compound.put("fluid", (Tag)this.tankWrapper.serializeNBT(registries));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"forcecraft.container.force_engine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
        return new ForceEngineMenu(id, playerInv, this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ForceEngineBlockEntity forceEngine) {
        if (!forceEngine.inputHandler.getStackInSlot(0).isEmpty()) {
            forceEngine.processFuelSlot();
            forceEngine.refreshClient();
        }
        if (!forceEngine.inputHandler.getStackInSlot(1).isEmpty()) {
            forceEngine.processThrottleSlot();
            forceEngine.refreshClient();
        }
        if (forceEngine.isActive() && forceEngine.canWork()) {
            forceEngine.checkFluids();
            if (forceEngine.getFuelAmount() > 0) {
                ++forceEngine.processTime;
                forceEngine.insertPower();
                if (forceEngine.processTime >= forceEngine.maxProcessTime) {
                    forceEngine.tankFuel.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    forceEngine.processTime = 0;
                }
            }
            if (forceEngine.getThrottleAmount() > 0) {
                ++forceEngine.throttleTime;
                if (forceEngine.throttleTime >= forceEngine.maxThrottleTime) {
                    forceEngine.tankThrottle.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    forceEngine.throttleTime = 0;
                }
            }
            forceEngine.refreshClient();
        } else if (forceEngine.processTime != 0) {
            forceEngine.processTime = 0;
        }
    }

    public void checkFluids() {
        if (this.cachedFuel == null || !this.getFuelFluid().isSame(this.cachedFuel)) {
            this.cachedFuel = this.getFuelFluid();
            this.reevaluateValues();
        }
        if (this.cachedThrottle == null || !this.getThrottleFluid().isSame(this.cachedThrottle)) {
            this.cachedThrottle = this.getThrottleFluid();
            this.reevaluateValues();
        }
    }

    public void reevaluateValues() {
        if (this.cachedFuel != null) {
            FluidStack fuelStack = this.getFuelFluidStack();
            this.processTime = 0;
            this.maxProcessTime = this.getTimePerFuelMB(fuelStack);
            this.generating = this.getPowerForFluid(fuelStack);
            this.throttleTime = 0;
            this.maxThrottleTime = this.getTimePerThrottleMB(this.getThrottleFluidStack());
        }
        this.refreshClient();
    }

    private float getThrottleValue() {
        FluidStack throttleStack = this.getThrottleFluidStack();
        if (!throttleStack.isEmpty()) {
            Fluid fluid = throttleStack.getFluid();
            if (fluid.is(ForceTags.MILK)) {
                return 2.5f;
            }
            if (fluid.isSame((Fluid)Fluids.WATER)) {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    public int getPowerForFluid(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            float throttleValue = this.getThrottleValue();
            Fluid fluid = fluidStack.getFluid();
            if (fluid.is(ForceTags.FORCE)) {
                return (int)(20.0f * throttleValue);
            }
            if (fluid.is(FluidTags.LAVA)) {
                return (int)(5.0f * throttleValue);
            }
            if (fluid.is(ForceTags.FUEL)) {
                return (int)(10.0f * throttleValue);
            }
            if (fluid.is(ForceTags.BIOFUEL)) {
                return (int)(15.0f * throttleValue);
            }
        }
        return 0;
    }

    public int getTimePerFuelMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.is(ForceTags.FORCE)) {
                return 20;
            }
            if (fluid.is(FluidTags.LAVA)) {
                return 20;
            }
            if (fluid.is(ForceTags.FUEL)) {
                return 20;
            }
            if (fluid.is(ForceTags.BIOFUEL)) {
                return 20;
            }
        }
        return 0;
    }

    public int getTimePerThrottleMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.is(ForceTags.MILK)) {
                return 5;
            }
            if (fluid.isSame((Fluid)Fluids.WATER)) {
                return 5;
            }
        }
        return 0;
    }

    public boolean isActive() {
        return this.getBlockState().getBlock() instanceof ForceEngineBlock && (Boolean)this.getBlockState().getValue((Property)ForceEngineBlock.ACTIVE) != false;
    }

    public Direction getFacing() {
        if (this.getBlockState().getBlock() instanceof ForceEngineBlock) {
            return (Direction)this.getBlockState().getValue((Property)ForceEngineBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean canWork() {
        IEnergyStorage cap;
        BlockPos offsetPos;
        BlockEntity tile;
        if (this.level != null && (tile = this.level.getBlockEntity(offsetPos = this.worldPosition.relative(this.getFacing()))) != null && (cap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, offsetPos, (Object)this.getFacing().getOpposite())) != null) {
            return cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored() && !this.tankFuel.getFluid().isEmpty();
        }
        return false;
    }

    public void insertPower() {
        IEnergyStorage cap;
        BlockEntity tile;
        BlockPos offsetPos = this.worldPosition.relative(this.getFacing());
        if (this.level != null && (tile = this.level.getBlockEntity(offsetPos)) != null && (cap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, offsetPos, (Object)this.getFacing().getOpposite())) != null && cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
            cap.receiveEnergy((int)this.generating, false);
        }
    }

    private void processFuelSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.stackWrapper.getStackInSlot(0);
        if (slotStack.is(ForceTags.FORCE_GEM)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity()) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.shrink(1);
            }
        } else if (slotStack.is(Tags.Items.NETHER_STARS)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 5000);
            ItemStack extraSlot = this.outputHandler.getStackInSlot(0);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity() && extraSlot.getCount() < this.inputHandler.getSlotLimit(1)) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.shrink(1);
                if (this.outputHandler.getStackInSlot(0).isEmpty()) {
                    this.outputHandler.setStackInSlot(0, new ItemStack((ItemLike)ForceRegistry.INERT_CORE.get()));
                } else {
                    extraSlot.setCount(extraSlot.getCount() + 1);
                }
            }
        } else if (this.outputHandler.getStackInSlot(0).isEmpty() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankFuel, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.shrink(1);
            this.outputHandler.setStackInSlot(0, result.getResult());
        }
    }

    public int fillFuel(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankFuel.getFluid().isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tankFuel.getFluid(), (FluidStack)resource))) {
            this.tankFuel.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    private void processThrottleSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.inputHandler.getStackInSlot(1);
        if (this.outputHandler.getStackInSlot(1).isEmpty() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankThrottle, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.shrink(1);
            this.outputHandler.setStackInSlot(1, result.getResult());
        }
    }

    public int fillThrottle(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankThrottle.getFluid().isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tankThrottle.getFluid(), (FluidStack)resource))) {
            this.tankThrottle.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFuelFluid() {
        return this.getFuelFluidStack().getFluid();
    }

    public FluidStack getFuelFluidStack() {
        return this.tankFuel.getFluid();
    }

    public int getFuelAmount() {
        return this.tankFuel.getFluidAmount();
    }

    public void setFuelAmount(int amount) {
        if (amount > 0) {
            if (!this.tankFuel.getFluid().isEmpty()) {
                this.tankFuel.getFluid().setAmount(amount);
            }
        } else {
            this.tankFuel.setFluid(FluidStack.EMPTY);
        }
    }

    public Fluid getThrottleFluid() {
        return this.getThrottleFluidStack().getFluid();
    }

    public FluidStack getThrottleFluidStack() {
        return this.tankThrottle.getFluid();
    }

    public int getThrottleAmount() {
        return this.tankThrottle.getFluidAmount();
    }

    public void setThrottleAmount(int amount) {
        if (amount > 0) {
            if (!this.tankThrottle.getFluid().isEmpty()) {
                this.tankThrottle.getFluid().setAmount(amount);
            }
        } else {
            this.tankThrottle.setFluid(FluidStack.EMPTY);
        }
    }

    protected boolean isFluidEqual(FluidTank fluidTank, FluidStack fluid) {
        return this.isFluidEqual(fluidTank, fluid.getFluid());
    }

    protected boolean isFluidEqual(FluidTank fluidTank, Fluid fluid) {
        return fluidTank.getFluid().getFluid().equals(fluid);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    private void refreshClient() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public ItemStackHandlerWrapper getItemHandler(@Nullable Direction facing) {
        return this.stackWrapper;
    }

    public FluidHandlerWrapper getFluidTank(@Nullable Direction facing) {
        return this.tankWrapper;
    }
}

