/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.capabilities;

import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IItemRepository {
    @NotNull
    public NonNullList<ItemRecord> getAllItems();

    @NotNull
    public ItemStack insertItem(@NotNull ItemStack var1, boolean var2, Predicate<ItemStack> var3);

    @NotNull
    default public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, null);
    }

    @NotNull
    public ItemStack extractItem(@NotNull ItemStack var1, int var2, boolean var3, Predicate<ItemStack> var4);

    @NotNull
    default public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate) {
        return this.extractItem(stack, amount, simulate, null);
    }

    default public int getStoredItemCount(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        ItemStack amount = this.extractItem(stack, Integer.MAX_VALUE, true, predicate);
        return amount.getCount();
    }

    default public int getStoredItemCount(@NotNull ItemStack stack) {
        return this.getStoredItemCount(stack, null);
    }

    default public int getRemainingItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        stack = stack.copy();
        stack.setCount(Integer.MAX_VALUE);
        ItemStack remainder = this.insertItem(stack, true, predicate);
        return Integer.MAX_VALUE - remainder.getCount();
    }

    default public int getRemainingItemCapacity(@NotNull ItemStack stack) {
        return this.getRemainingItemCapacity(stack, null);
    }

    default public int getItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
        long capacity = (long)this.getStoredItemCount(stack, predicate) + (long)this.getRemainingItemCapacity(stack, predicate);
        if (capacity > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    default public int getItemCapacity(@NotNull ItemStack stack) {
        return this.getItemCapacity(stack, null);
    }

    public static interface DefaultPredicate<T>
    extends Predicate<T> {
    }

    public static class ItemRecord {
        @NotNull
        public final ItemStack itemPrototype;
        public final int count;

        public ItemRecord(@NotNull ItemStack itemPrototype, int count) {
            this.itemPrototype = itemPrototype;
            this.count = count;
        }
    }
}

