/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public record Blacklist(List<String> namespaces, List<ResourceLocation> entities, List<ResourceLocation> blocks, List<ResourceLocation> blockEntities, List<ResourceLocation> items) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ResourceLocation.class, (Object)new TypeAdapter<Object>(){

        public void write(JsonWriter out, Object value) throws IOException {
            if (value instanceof ResourceLocation) {
                ResourceLocation id = (ResourceLocation)value;
                out.value(id.toString());
            } else if (value == null) {
                out.nullValue();
            }
        }

        public Object read(JsonReader in) throws IOException {
            String value = in.nextString();
            ResourceLocation identifier = ResourceLocation.tryParse((String)value);
            if (identifier == null) {
                throw new IOException("Invalid ResourceLocation: " + value);
            }
            return identifier;
        }
    }).create();

    public static Blacklist fromJson(JsonReader reader) {
        return (Blacklist)GSON.fromJson(reader, Blacklist.class);
    }

    public boolean isBlacklisted(ErroredType type, ResourceLocation id) {
        if (id == null) {
            return false;
        }
        if (this.namespaces != null) {
            for (String namespace : this.namespaces) {
                if (!id.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return switch (type) {
            case ErroredType.ENTITY -> {
                if (this.entities != null && this.entities.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.BLOCK_STATE -> {
                if (this.blocks != null && this.blocks.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.BLOCK_ENTITY -> {
                if (this.blockEntities != null && this.blockEntities.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.ITEM_STACK -> {
                if (this.items != null && this.items.contains(id)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

