/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import reliquary.init.ModItems;
import reliquary.item.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;

public class LanternOfParanoiaItem
extends ToggleableItem {
    private static final int SUCCESS_COOLDOWN = 4;
    private static final int NOTHING_FOUND_COOLDOWN = 10;
    private static final Map<String, Block> TORCH_BLOCKS = new HashMap<String, Block>();

    public LanternOfParanoiaItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.YELLOW);
    }

    public int getRange() {
        return (Integer)Config.COMMON.items.lanternOfParanoia.placementScanRadius.get();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || !this.isEnabled(stack) || this.isInCooldown(stack, level)) {
            return;
        }
        if (this.getPositionsInRange(player).anyMatch(pos -> this.tryToPlaceAtPos(stack, level, player, (BlockPos)pos))) {
            this.setCooldown(stack, level, 4);
        } else {
            this.setCooldown(stack, level, 10);
        }
    }

    private Stream<BlockPos> getPositionsInRange(Player player) {
        return BlockPos.betweenClosedStream((BlockPos)player.blockPosition().offset(-this.getRange(), -this.getRange() / 2, -this.getRange()), (BlockPos)player.blockPosition().offset(this.getRange(), this.getRange() / 2, this.getRange()));
    }

    private boolean tryToPlaceAtPos(ItemStack stack, Level level, Player player, BlockPos pos) {
        BlockPlaceContext context;
        Block block;
        int lightLevel = player.level().getBrightness(LightLayer.BLOCK, pos);
        if (lightLevel > (Integer)Config.COMMON.items.lanternOfParanoia.minLightLevel.get()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (this.isBadPlacementToTry(level, pos, state, block = state.getBlock(), context = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)pos), Direction.UP, pos, false)))) {
            return false;
        }
        return this.tryToPlaceTorchAround(stack, pos, player, level);
    }

    private boolean isBadPlacementToTry(Level level, BlockPos pos, BlockState state, Block block, BlockPlaceContext context) {
        return block instanceof LiquidBlock || level.getBlockState(pos.below()).getBlock().hasDynamicShape() || !state.getFluidState().isEmpty() || !state.isAir() && !state.canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)pos, (Direction)Direction.DOWN));
    }

    private boolean isBlockBlockingView(Level level, Player player, BlockPos pos) {
        double playerEyeHeight = player.getY() + (double)player.getEyeHeight();
        for (float xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    Vec3 rayTraceVector;
                    Vec3 playerVec = new Vec3(player.getX() + (double)xOff, playerEyeHeight + (double)yOff, player.getZ() + (double)zOff);
                    BlockHitResult rayTraceResult = level.clip(new ClipContext(playerVec, rayTraceVector = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5 + (double)xOff, 0.5 + (double)yOff, 0.5 + (double)zOff), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                    if (rayTraceResult.getType() != HitResult.Type.MISS) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean tryToPlaceTorchAround(ItemStack stack, BlockPos pos, Player player, Level level) {
        if (this.isBlockBlockingView(level, player, pos)) {
            return false;
        }
        for (String torchRegistryName : (List)Config.COMMON.items.lanternOfParanoia.torches.get()) {
            if (!this.getTorchBlock(torchRegistryName).map(torch -> this.tryToPlaceTorchBlock(stack, pos, player, level, (Block)torch)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tryToPlaceTorchBlock(ItemStack stack, BlockPos pos, Player player, Level level, Block torch) {
        if (torch.defaultBlockState().canSurvive((LevelReader)level, pos)) {
            ArrayList trySides = Lists.newArrayList((Object[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
            ItemStack torchStack = new ItemStack((ItemLike)torch);
            for (Direction side : trySides) {
                BlockState torchBlockState = this.getTorchSideAttempt(player, torch, pos, side);
                if (torchBlockState == null || !torchBlockState.canSurvive((LevelReader)level, pos) || !level.isUnobstructed(torchBlockState, pos, CollisionContext.empty()) || !InventoryHelper.consumeItem(torchStack, player, 0, 1) && !this.findAndDrainSojournersStaff(player, torchStack.getItem()) || !this.placeBlockAt(stack, player, level, pos, torchBlockState)) continue;
                float gauss = 0.5f + level.random.nextFloat() / 2.0f;
                level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)gauss, (float)gauss, (float)0.0f), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                SoundType torchSoundType = torch.getSoundType(torchBlockState, (LevelReader)level, pos, null);
                level.playSound(null, pos, torchSoundType.getStepSound(), SoundSource.BLOCKS, (torchSoundType.getVolume() + 1.0f) / 2.0f, torchSoundType.getPitch() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private boolean findAndDrainSojournersStaff(Player player, Item torchItem) {
        if (player.isCreative()) {
            return true;
        }
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            if (player.getInventory().getItem(slot).getItem() != ModItems.SOJOURNER_STAFF.get() || !ModItems.SOJOURNER_STAFF.get().removeTorch(player.getInventory().getItem(slot))) continue;
            return true;
        }
        return false;
    }

    private Optional<Block> getTorchBlock(String registryName) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)registryName));
        if (block == Blocks.AIR) {
            return Optional.empty();
        }
        return Optional.of(TORCH_BLOCKS.computeIfAbsent(registryName, rn -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)rn))));
    }

    @Nullable
    private BlockState getTorchSideAttempt(Player player, Block torch, BlockPos pos, Direction side) {
        return torch.getStateForPlacement(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)pos), side, pos, false)));
    }

    private boolean placeBlockAt(ItemStack stack, Player player, Level level, BlockPos pos, BlockState torchBlockState) {
        if (!level.setBlock(pos, torchBlockState, 3)) {
            return false;
        }
        torchBlockState.getBlock().setPlacedBy(level, pos, torchBlockState, (LivingEntity)player, stack);
        return true;
    }
}

