/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import reliquary.entity.SpecialSnowball;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.GlacialStaffItem;
import reliquary.reference.Config;
import reliquary.util.TooltipBuilder;

public class IceMagusRodItem
extends ChargeableItem {
    public static final DustParticleOptions ICE_PARTICLE = new DustParticleOptions(new Vector3f(0.3882353f, 0.76862746f, 0.99215686f), 1.0f);

    public IceMagusRodItem() {
        super(new Item.Properties().stacksTo(1).setNoRepair().rarity(Rarity.EPIC));
    }

    @Override
    protected void addMoreInformation(ItemStack rod, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", IceMagusRodItem.getSnowballs(rod));
        if (this.isEnabled(rod)) {
            tooltipBuilder.absorbActive(Items.SNOWBALL.getName(new ItemStack((ItemLike)Items.SNOWBALL)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private int getSnowballLimit() {
        return this instanceof GlacialStaffItem ? (Integer)Config.COMMON.items.glacialStaff.snowballLimit.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballLimit.get();
    }

    int getSnowballCost() {
        return this instanceof GlacialStaffItem ? (Integer)Config.COMMON.items.glacialStaff.snowballCost.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballCost.get();
    }

    private int getSnowballWorth() {
        return this instanceof GlacialStaffItem ? (Integer)Config.COMMON.items.glacialStaff.snowballWorth.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballWorth.get();
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return slot == 0 && stack.is(Items.SNOWBALL);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.swing(hand);
        if (!player.isShiftKeyDown() && (IceMagusRodItem.getSnowballs(stack) >= this.getSnowballCost() || player.isCreative())) {
            level.playSound(null, player.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            SpecialSnowball snowball = new SpecialSnowball(level, (LivingEntity)player, this instanceof GlacialStaffItem);
            snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.4f, 1.0f);
            level.addFreshEntity((Entity)snowball);
            if (!player.isCreative()) {
                this.useCharge(stack, this.getSnowballCost());
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        containerStack.set(ModDataComponents.SNOWBALLS, (Object)Math.max(0, Math.min(IceMagusRodItem.getSnowballs(containerStack) + chargeToAdd, this.getSnowballLimit())));
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? this.getSnowballWorth() : 0;
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        return IceMagusRodItem.getSnowballs(containerStack);
    }

    public static int getSnowballs(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.SNOWBALLS, (Object)0);
    }

    public void inventoryTick(ItemStack rod, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.isEnabled(rod)) {
            int snowCharge = IceMagusRodItem.getSnowballs(rod);
            this.consumeAndCharge(rod, 0, player, this.getSnowballLimit() - snowCharge, 1, 16);
        }
    }
}

