/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.alkahestry;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import reliquary.Reliquary;
import reliquary.compat.jei.alkahestry.AlkahestryRecipeCategory;
import reliquary.crafting.AlkahestryChargingRecipe;

public class AlkahestryChargingRecipeCategory
extends AlkahestryRecipeCategory<AlkahestryChargingRecipe> {
    public static final RecipeType<AlkahestryChargingRecipe> TYPE = RecipeType.create((String)"reliquary", (String)"alkahestry_charging", AlkahestryChargingRecipe.class);
    private final IDrawable background;
    private final Component localizedName;

    public AlkahestryChargingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(Reliquary.getRL("textures/gui/jei/backgrounds.png"), 0, 0, 95, 36);
        this.localizedName = Component.translatable((String)"jei.reliquary.recipe.alkahest_charging");
    }

    public RecipeType<AlkahestryChargingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlkahestryChargingRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredientsInputs = recipe.getIngredients();
        ItemStack input = ((Ingredient)ingredientsInputs.get(0)).getItems()[0];
        ItemStack tome = ((Ingredient)ingredientsInputs.get(1)).getItems()[0];
        ItemStack output = recipe.getRecipeOutput();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStack(input);
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStack(tome);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 10).addItemStack(output);
    }

    public void draw(AlkahestryChargingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String chargeString = "+" + recipe.getChargeToAdd();
        Font fontRenderer = Minecraft.getInstance().font;
        int stringWidth = fontRenderer.width(chargeString);
        guiGraphics.drawString(fontRenderer, chargeString, (int)(((double)this.background.getWidth() - (double)stringWidth) / 2.0), 3, -8355712);
    }
}

