/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.integration.jei;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.inworldrecipes.integration.jei.JEIInWorldRecipesPlugin;
import com.benbenlaw.inworldrecipes.recipes.BlockInteractionRecipe;
import com.benbenlaw.inworldrecipes.recipes.BlockTarget;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsBlockRecipe;
import com.benbenlaw.inworldrecipes.util.ClickType;
import com.benbenlaw.inworldrecipes.util.JEIBlockRenderHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInteractionRecipeCategory
implements IRecipeCategory<BlockInteractionRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"block_interaction");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"textures/gui/jei_block_interaction.png");
    static final RecipeType<BlockInteractionRecipe> RECIPE_TYPE = RecipeType.create((String)"inworldrecipes", (String)"block_interaction", BlockInteractionRecipe.class);
    int yOffset = 21;
    int totalMessages;
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(BlockInteractionRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RightClickOnBlockTransformsBlockRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((RightClickOnBlockTransformsBlockRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public BlockInteractionRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK));
    }

    @NotNull
    public RecipeType<BlockInteractionRecipe> getRecipeType() {
        return JEIInWorldRecipesPlugin.BLOCK_INTERACTION_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Block Interaction");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final BlockInteractionRecipe recipe, @NotNull IFocusGroup focusGroup) {
        Block outputBlock;
        this.totalMessages = 0;
        BlockTarget blockTarget = recipe.targetBlock();
        if (blockTarget instanceof BlockTarget.Single) {
            final BlockTarget.Single single = (BlockTarget.Single)blockTarget;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addItemStack(new ItemStack((ItemLike)single.blockState().getBlock()))).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(this){

                public void render(GuiGraphics guiGraphics, ItemStack stack) {
                    JEIBlockRenderHelper.renderBlock(guiGraphics, single.blockState(), 1, 12, 0.6f);
                }

                public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
                    ArrayList<Component> tooltip = new ArrayList<Component>();
                    tooltip.add((Component)single.blockState().getBlock().getName());
                    BlockState targetState = single.blockState();
                    BlockState defaultState = targetState.getBlock().defaultBlockState();
                    for (Map.Entry entry : targetState.getValues().entrySet()) {
                        Comparable defaultValue;
                        Property property = (Property)entry.getKey();
                        Comparable recipeValue = (Comparable)entry.getValue();
                        if (recipeValue.equals(defaultValue = defaultState.getValue(property))) continue;
                        String key = property.getName();
                        String value = recipeValue.toString();
                        tooltip.add((Component)Component.literal((String)(key + ": " + value)));
                    }
                    return tooltip;
                }
            });
        } else {
            TagKey<Block> tag = ((BlockTarget.Tag)recipe.targetBlock()).tag();
            TagKey itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag.location());
            builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addIngredients(Ingredient.of((TagKey)itemTag));
        }
        Block block = recipe.outputBlockState() != null && recipe.outputBlockState().getBlock() != Blocks.AIR ? recipe.outputBlockState().getBlock() : (outputBlock = !recipe.chanceResults().isEmpty() ? Blocks.CHEST : Blocks.BARRIER);
        if (outputBlock instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)outputBlock;
            FlowingFluid fluid = liquidBlock.fluid;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addFluidStack((Fluid)fluid);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addItemStack(new ItemStack((ItemLike)outputBlock))).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(this){

            public void render(GuiGraphics guiGraphics, ItemStack stack) {
                Block renderBlock = recipe.outputBlockState() != null && recipe.outputBlockState().getBlock() != Blocks.AIR ? recipe.outputBlockState().getBlock() : (!recipe.chanceResults().isEmpty() ? Blocks.CHEST : Blocks.BARRIER);
                JEIBlockRenderHelper.renderBlock(guiGraphics, renderBlock.defaultBlockState(), 1, 12, 0.6f);
            }

            public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                BlockState outputState = recipe.outputBlockState();
                if (outputState == null) {
                    tooltip.add((Component)Component.literal((String)"Block destroyed!").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    Block outputBlock = outputState.getBlock();
                    tooltip.add((Component)outputBlock.getName());
                    for (Map.Entry entry : outputState.getValues().entrySet()) {
                        String key = ((Property)entry.getKey()).getName();
                        String value = ((Comparable)entry.getValue()).toString();
                        tooltip.add((Component)Component.literal((String)(key + ": " + value)));
                    }
                }
                NonNullList<ChanceResult> results = recipe.chanceResults();
                if (!results.isEmpty()) {
                    tooltip.add((Component)Component.literal((String)"Chance Results:").withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD}));
                    for (ChanceResult result : results) {
                        ItemStack stack = result.stack();
                        int count = stack.getCount();
                        Component baseName = stack.getHoverName();
                        Component itemDisplayName = count > 1 ? Component.literal((String)(count + "x ")).append(baseName) : baseName;
                        String chancePercent = String.format("%.1f%%", Float.valueOf(result.chance() * 100.0f));
                        tooltip.add((Component)Component.literal((String)" - ").append(itemDisplayName).append(": ").append((Component)Component.literal((String)chancePercent)).withStyle(ChatFormatting.GOLD));
                    }
                }
                return tooltip;
            }
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 76, 2).addIngredients(recipe.heldItem().ingredient());
        NonNullList<ChanceResult> results = recipe.chanceResults();
        if (!results.isEmpty()) {
            for (ChanceResult result : results) {
                ItemStack stack = result.stack();
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 2).addItemStack(stack)).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(this){

                    public void render(GuiGraphics guiGraphics, ItemStack stack) {
                    }

                    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
                        return List.of(ingredient.getHoverName());
                    }
                });
            }
        }
        if (recipe.damageHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.consumeHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.popItems()) {
            ++this.totalMessages;
        }
        if (recipe.outputBlockState() != null && recipe.outputBlockState().getBlock().defaultBlockState().is(Blocks.AIR)) {
            ++this.totalMessages;
        }
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 139, 18 + this.totalMessages * 10);
    }

    public void draw(BlockInteractionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.clickType() == ClickType.LEFT_CLICK) {
            guiGraphics.blit(TEXTURE, 39, 1, 158, 0, 18, 18);
        }
        if (recipe.clickType() == ClickType.RIGHT_CLICK) {
            guiGraphics.blit(TEXTURE, 39, 1, 140, 0, 18, 18);
        }
        if (mouseX >= 40.0 && mouseX < 58.0 && mouseY >= 2.0 && mouseY < 20.0) {
            if (recipe.clickType() == ClickType.LEFT_CLICK) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.inworldrecipe.left_click"), (int)mouseX, (int)mouseY);
            } else {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.inworldrecipe.right_click"), (int)mouseX, (int)mouseY);
            }
        }
        this.yOffset = 20;
        if (recipe.damageHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Damages Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.consumeHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Consumes Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.popItems()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Item Drops In World", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.outputBlockState() != null && recipe.outputBlockState().getBlock().defaultBlockState().is(Blocks.AIR)) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Destroys Target Block", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
    }
}

