/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class BeltModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<BeltBlockEntity.CasingType> CASING_PROPERTY = new ModelProperty();
    public static final ModelProperty<Boolean> COVER_PROPERTY = new ModelProperty();
    private static final SpriteShiftEntry SPRITE_SHIFT = AllSpriteShifts.ANDESIDE_BELT_CASING;

    public BeltModel(BakedModel template) {
        super(template);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        if (!data.has(CASING_PROPERTY)) {
            return super.getParticleIcon(data);
        }
        BeltBlockEntity.CasingType type = (BeltBlockEntity.CasingType)((Object)data.get(CASING_PROPERTY));
        if (type == BeltBlockEntity.CasingType.NONE || type == BeltBlockEntity.CasingType.BRASS) {
            return super.getParticleIcon(data);
        }
        return AllSpriteShifts.ANDESITE_CASING.getOriginal();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        boolean brassCasing;
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(CASING_PROPERTY)) {
            return quads;
        }
        boolean cover = (Boolean)extraData.get(COVER_PROPERTY);
        BeltBlockEntity.CasingType type = (BeltBlockEntity.CasingType)((Object)extraData.get(CASING_PROPERTY));
        boolean bl = brassCasing = type == BeltBlockEntity.CasingType.BRASS;
        if (type == BeltBlockEntity.CasingType.NONE || brassCasing && !cover) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        if (cover) {
            boolean alongX;
            boolean bl2 = alongX = ((Direction)state.getValue(BeltBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X;
            BakedModel coverModel = (brassCasing ? (alongX ? AllPartialModels.BRASS_BELT_COVER_X : AllPartialModels.BRASS_BELT_COVER_Z) : (alongX ? AllPartialModels.ANDESITE_BELT_COVER_X : AllPartialModels.ANDESITE_BELT_COVER_Z)).get();
            quads.addAll(coverModel.getQuads(state, side, rand, extraData, renderType));
        }
        if (brassCasing) {
            return quads;
        }
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            TextureAtlasSprite original = quad.getSprite();
            if (original != SPRITE_SHIFT.getOriginal()) continue;
            BakedQuad newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.getVertices();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, SPRITE_SHIFT.getTargetU(u));
                BakedQuadHelper.setV(vertexData, vertex, SPRITE_SHIFT.getTargetV(v));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

