/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.RegulatorFilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.utils.IFAttachments;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class FilteredTransporterType<TYPE, CAP>
extends TransporterType {
    private RegulatorFilter<TYPE, CAP> filter = this.createFilter();

    public FilteredTransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        if (buttonId >= 0 && buttonId < this.filter.getFilterSlots().length) {
            if (compound.contains("Amount")) {
                this.filter.getFilterSlots()[buttonId].increaseAmount(compound.getInt("Amount"));
            } else {
                this.filter.setFilter(buttonId, ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)compound));
            }
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.filter.setWhitelisted(!this.filter.isWhitelisted());
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.filter.setRegulated(!this.filter.isRegulated());
            this.getContainer().requestSync();
        }
    }

    public abstract RegulatorFilter<TYPE, CAP> createFilter();

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new RegulatorFilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public RegulatorFilter<TYPE, CAP> getFilter() {
                return FilteredTransporterType.this.filter;
            }
        });
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return FilteredTransporterType.this.filter.isWhitelisted() ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 40, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 58, 233, new String[]{"regulated_true"}), new StateButtonInfo(1, res, 77, 233, new String[]{"regulated_false"})}){

            @Override
            public int getState() {
                return FilteredTransporterType.this.filter.isRegulated() ? 0 : 1;
            }
        });
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = super.serializeNBT(provider);
        compoundNBT.put("Filter", (Tag)this.filter.serializeNBT(provider));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(provider, nbt.getCompound("Filter"));
        }
    }

    public RegulatorFilter<TYPE, CAP> getFilter() {
        return this.filter;
    }
}

