/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.loot_tables;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tallestegg.illagersweararmor.loot_tables.ArmorSlotFunction;
import tallestegg.illagersweararmor.loot_tables.RaidWaveCondition;

public class IWALootTables {
    public static final BiMap<ResourceLocation, LootContextParamSet> REGISTRY = HashBiMap.create();
    public static final LootContextParamSet SLOT = IWALootTables.register("slot", table -> table.required(LootContextParams.THIS_ENTITY));
    public static final DeferredRegister<LootItemFunctionType<?>> LOOT_ITEM_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"illagersweararmor");
    public static final DeferredRegister<LootItemConditionType> LOOT_ITEM_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"illagersweararmor");
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> WAVE = LOOT_ITEM_CONDITION_TYPES.register("wave", () -> RaidWaveCondition.TYPE);
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<ArmorSlotFunction>> ARMOR_SLOT = LOOT_ITEM_FUNCTION_TYPES.register("slot", () -> new LootItemFunctionType(ArmorSlotFunction.CODEC));
    public static final ResourceKey<LootTable> ILLAGER_HELMET = IWALootTables.registerLootTable("entities/illager_helmet");
    public static final ResourceKey<LootTable> ILLAGER_CHEST = IWALootTables.registerLootTable("entities/illager_chestplate");
    public static final ResourceKey<LootTable> ILLAGER_LEGGINGS = IWALootTables.registerLootTable("entities/illager_legs");
    public static final ResourceKey<LootTable> ILLAGER_FEET = IWALootTables.registerLootTable("entities/illager_feet");
    public static final ResourceKey<LootTable> NATURAL_SPAWN_ILLAGER_HELMET = IWALootTables.registerLootTable("entities/natural_spawn/illager_helmet");
    public static final ResourceKey<LootTable> NATURAL_SPAWN_ILLAGER_CHEST = IWALootTables.registerLootTable("entities/natural_spawn/illager_chestplate");
    public static final ResourceKey<LootTable> NATURAL_SPAWN_ILLAGER_LEGGINGS = IWALootTables.registerLootTable("entities/natural_spawn/illager_legs");
    public static final ResourceKey<LootTable> NATURAL_SPAWN_ILLAGER_FEET = IWALootTables.registerLootTable("entities/natural_spawn/illager_feet");
    public static final ResourceKey<LootTable> VEX_HELMET = IWALootTables.registerLootTable("entities/natural_spawn/vex_helmet");
    public static final ResourceKey<LootTable> VEX_CHEST = IWALootTables.registerLootTable("entities/natural_spawn/vex_chestplate");
    public static final ResourceKey<LootTable> VEX_LEGGINGS = IWALootTables.registerLootTable("entities/natural_spawn/vex_legs");
    public static final ResourceKey<LootTable> VEX_FEET = IWALootTables.registerLootTable("entities/natural_spawn/vex_feet");

    public static ResourceKey<LootTable> registerLootTable(String id) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"illagersweararmor", (String)id));
    }

    public static LootContextParamSet register(String p_81429_, Consumer<LootContextParamSet.Builder> p_81430_) {
        LootContextParamSet.Builder lootcontextparamset$builder = new LootContextParamSet.Builder();
        p_81430_.accept(lootcontextparamset$builder);
        LootContextParamSet lootcontextparamset = lootcontextparamset$builder.build();
        ResourceLocation resourcelocation = ResourceLocation.parse((String)("illagersweararmor" + p_81429_));
        LootContextParamSet lootcontextparamset1 = (LootContextParamSet)REGISTRY.put((Object)resourcelocation, (Object)lootcontextparamset);
        if (lootcontextparamset1 != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf(resourcelocation) + " is already registered");
        }
        return lootcontextparamset;
    }
}

