/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAHelper;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

public class IWASpawnEvents {
    @SubscribeEvent
    public static void finalizeSpawn(FinalizeSpawnEvent event) {
        MobSpawnType spawnType = event.getSpawnType();
        Mob entity = event.getEntity();
        if (!IWAConfig.ArmorBlackList.contains(entity.getEncodeId())) {
            Mob mob;
            if (entity instanceof Raider) {
                Raider raider = (Raider)entity;
                if ((entity instanceof AbstractIllager || entity instanceof Witch) && IWAConfig.IllagerArmor) {
                    if (raider.getCurrentRaid() != null && spawnType == MobSpawnType.EVENT) {
                        raider.getTags().add("raidArmorSpawn");
                    } else {
                        raider.getTags().add("naturalArmorSpawn");
                    }
                }
            }
            if ((mob = event.getEntity()) instanceof Vex) {
                Vex vex = (Vex)mob;
                vex.getTags().add("naturalArmorSpawn");
            }
        }
    }

    @SubscribeEvent
    public static void tickEntity(EntityTickEvent.Pre event) {
        Vex vex;
        Entity entity = event.getEntity();
        if (entity instanceof Raider) {
            Raider raider = (Raider)entity;
            if (raider.getTags().contains("raidArmorSpawn")) {
                IWASpawnEvents.giveArmorOnRaids(raider, raider.getRandom());
                raider.getTags().remove("raidArmorSpawn");
            } else if (raider.getTags().contains("naturalArmorSpawn")) {
                IWASpawnEvents.getItemsFromLootTable((LivingEntity)raider);
                raider.getTags().remove("naturalArmorSpawn");
            }
        }
        if ((entity = event.getEntity()) instanceof Vex && (vex = (Vex)entity).getTags().contains("naturalArmorSpawn")) {
            IWASpawnEvents.getItemsFromLootTable((LivingEntity)vex);
            vex.getTags().remove("naturalArmorSpawn");
        }
    }

    public static void giveArmorOnRaids(Raider raider, RandomSource pRandom) {
        if (raider.getCurrentRaid() == null) {
            return;
        }
        if (pRandom.nextFloat() < IWAHelper.getWaveArmorChances(raider.getWave())) {
            IWASpawnEvents.getItemsFromLootTable((LivingEntity)raider);
        }
    }

    public static List<ItemStack> getItemsFromLootTable(LivingEntity entity) {
        Raider raider;
        boolean raiding = entity instanceof Raider && (raider = (Raider)entity).getCurrentRaid() != null;
        LootTable loot = entity.level().getServer().reloadableRegistries().getLootTable(IWASpawnEvents.getLootTable(entity, raiding));
        if (loot == LootTable.EMPTY) {
            String inRaid = raiding ? "_raid" : "";
            ResourceKey lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"illagersweararmor", (String)("entities/illager" + inRaid)));
            loot = entity.level().getServer().reloadableRegistries().getLootTable(lootTable);
        }
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        return loot.getRandomItems(lootcontext$builder.create(IWALootTables.SLOT));
    }

    public static ResourceKey<LootTable> getLootTable(LivingEntity entity, boolean raid) {
        String illagerName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getPath();
        String inRaid = raid ? "_raid" : "";
        ResourceLocation lootTable = ResourceLocation.fromNamespaceAndPath((String)"illagersweararmor", (String)("entities/" + illagerName + inRaid));
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable);
    }
}

