/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.List;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RitualBinding
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world.isClientSide) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 10; ++i) {
                Vec3 particlePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 0.0, 0.5);
                particlePos = particlePos.add(ParticleUtil.pointInSphere().multiply(5.0, 5.0, 5.0));
                world.addParticle(ParticleLineData.createData(this.getCenterColor()), particlePos.x(), particlePos.y(), particlePos.z(), (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            }
        }
        if (!world.isClientSide && world.getGameTime() % 20L == 0L) {
            this.incrementProgress();
            if (this.getProgress() >= 3) {
                List entities = this.getWorld().getEntitiesOfClass(Entity.class, new AABB(this.getPos()).inflate(5.0));
                for (Entity entity : entities) {
                    for (AbstractFamiliarHolder familiarHolder : FamiliarRegistry.getFamiliarHolderMap().values()) {
                        if (!familiarHolder.isEntity.test(entity)) continue;
                        entity.remove(Entity.RemovalReason.DISCARDED);
                        ParticleUtil.spawnPoof((ServerLevel)world, entity.blockPosition());
                        Vec3 pos = entity.blockPosition().getBottomCenter();
                        world.addFreshEntity((Entity)new ItemEntity(world, pos.x, pos.y, pos.z, familiarHolder.getOutputItem()));
                        world.playSound(null, entity.blockPosition(), SoundEvents.BOOK_PUT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.FAMILIAR.get(), (ServerLevel)world, entity.blockPosition(), 8);
                    }
                }
                this.setFinished();
            }
        }
    }

    @Override
    public String getLangName() {
        return "Binding";
    }

    @Override
    public String getLangDescription() {
        return "The Ritual of Binding converts nearby eligible entities into Bound Scripts, used for summoning a Familiar. For more information, see the section on Familiars.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.BINDING);
    }
}

