/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.util;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.mojang.serialization.Codec;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class EquipmentModifierUtils {
    public static boolean isEffectAtMax(ItemStack stack, EquipmentModifier modifier) {
        boolean hasSilkTouch;
        int fortuneLevel;
        if (modifier == EquipmentModifier.SILK_TOUCH && (fortuneLevel = ((Integer)stack.getOrDefault((DataComponentType)EquipmentModifier.FORTUNE.dataComponent.get(), (Object)0)).intValue()) > 0) {
            return false;
        }
        if (modifier == EquipmentModifier.FORTUNE && (hasSilkTouch = ((Boolean)stack.getOrDefault((DataComponentType)EquipmentModifier.SILK_TOUCH.dataComponent.get(), (Object)false)).booleanValue())) {
            return false;
        }
        if (stack.getComponents().has((DataComponentType)modifier.dataComponent.get())) {
            if (modifier.codec == Codec.BOOL) {
                return (Boolean)stack.getOrDefault((DataComponentType)modifier.dataComponent.get(), (Object)false);
            }
            if (modifier.codec == Codec.INT) {
                int currentLevel = (Integer)stack.getOrDefault((DataComponentType)modifier.dataComponent.get(), (Object)0);
                return currentLevel >= modifier.maxLevel.get();
            }
            throw new IllegalArgumentException("Unsupported codec type for modifier: " + modifier.id);
        }
        return false;
    }

    public static ItemStack copyAndApplyEffect(ItemStack stack, EquipmentModifier modifier) {
        ItemStack copy = stack.copy();
        DataComponentType component = (DataComponentType)modifier.dataComponent.get();
        if (modifier.codec == Codec.BOOL) {
            boolean currentValue = (Boolean)stack.getOrDefault(component, (Object)false);
            copy.set(component, (Object)(!currentValue ? 1 : 0));
        } else if (modifier.codec == Codec.INT) {
            int currentLevel = (Integer)stack.getOrDefault(component, (Object)0);
            int newLevel = Math.min(currentLevel + 1, modifier.maxLevel.get());
            copy.set(component, (Object)newLevel);
        } else {
            throw new IllegalArgumentException("Unsupported codec type for modifier: " + modifier.id);
        }
        return copy;
    }

    public static boolean hasEnoughFreeModifiers(ItemStack stack, EquipmentModifier modifier) {
        if (!stack.has((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get())) {
            return true;
        }
        if (stack.has((DataComponentType)modifier.dataComponent.get())) {
            return true;
        }
        int toolLevel = (Integer)stack.getOrDefault((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get(), (Object)0);
        int modifierCount = 0;
        for (EquipmentModifier modifiers : EquipmentModifier.values()) {
            if (modifiers == EquipmentModifier.EQUIPMENT_LEVEL || !stack.has((DataComponentType)modifiers.dataComponent.get())) continue;
            ++modifierCount;
        }
        return toolLevel > modifierCount;
    }

    public static double getExperienceModifierLevel(int toolLevel) {
        return (float)toolLevel * ((Float)EquipmentModifierConfig.experienceMultiplierPerLevel.get()).floatValue();
    }
}

