/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.SolidifierRecipe;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.SequencedCollection;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolidifierRecipeCategory
implements IRecipeCategory<SolidifierRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"solidifier");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_solidifier.png");
    public static final RecipeType<SolidifierRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"solidifier", SolidifierRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(SolidifierRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SolidifierRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((SolidifierRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public SolidifierRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 132, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_SOLIDIFIER.get()));
    }

    @NotNull
    public RecipeType<SolidifierRecipe> getRecipeType() {
        return JEICastingPlugin.SOLIDIFIER_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.casting.jei.solidifier");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SolidifierRecipe recipe, IFocusGroup focusGroup) {
        int fluidAmount = recipe.fluid().getAmount();
        SequencedCollection ingredients = List.of(Arrays.stream(recipe.output().getItems())).reversed();
        List items = ingredients.stream().flatMap(stream -> stream).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addFluidStack(recipe.fluid().getFluid(), (long)recipe.fluid().getAmount()).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(recipe.fluid().getAmount() + " mB")).withStyle(ChatFormatting.GOLD)));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 40, 2).addFluidStack(recipe.fluid().getFluid(), 1000L);
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.mold().getItems()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 2).addItemStack(recipe.output().getItems()[0]);
    }

    public void draw(SolidifierRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        int fluidAmount = recipe.fluid().getAmount();
        String fluidText = fluidAmount + "mb";
        int textWidth = minecraft.font.width(fluidText);
        int xPosition = 76 - textWidth / 2;
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)fluidText), xPosition, 6, Color.GRAY.getRGB(), false);
    }
}

