/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity;

import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.item.util.FluidListComponent;
import com.benbenlaw.casting.recipe.CoolantRecipe;
import com.benbenlaw.casting.recipe.SolidifierRecipe;
import com.benbenlaw.casting.screen.SolidifierMenu;
import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolidifierBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            SolidifierBlockEntity.this.setChanged();
            SolidifierBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0 && stack.is(CastingTags.Items.MOLDS)) {
                return 1;
            }
            return 64;
        }
    };
    public final FluidTank TANK = new FluidTank(16000){

        protected void onContentsChanged() {
            SolidifierBlockEntity.this.setChanged();
            SolidifierBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return SolidifierBlockEntity.this.TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return SolidifierBlockEntity.this.TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return SolidifierBlockEntity.this.TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == SolidifierBlockEntity.this.TANK.getFluid().getFluid() || SolidifierBlockEntity.this.TANK.isEmpty()) {
                return SolidifierBlockEntity.this.TANK.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == SolidifierBlockEntity.this.TANK.getFluid().getFluid()) {
                return SolidifierBlockEntity.this.TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (SolidifierBlockEntity.this.TANK.getFluidAmount() > 0) {
                return SolidifierBlockEntity.this.TANK.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress;
    public int fuelTemp = 0;
    public int storedTankFluidAmount = 0;
    public int storedTankFluidAmountUsedInRecipe = 0;
    public boolean isLimitMode = false;
    private final IItemHandler solidifierItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
    public RecipeHolder<SolidifierRecipe> cachedRecipe = null;

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.TANK);
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void setFluid(FluidStack stack) {
        this.TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.TANK.getFluid();
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.solidifierItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public SolidifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.SOLIDIFIER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> SolidifierBlockEntity.this.progress;
                    case 1 -> SolidifierBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        SolidifierBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        SolidifierBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    private boolean isRecipeStillValid(@NotNull RecipeHolder<SolidifierRecipe> holder) {
        SolidifierRecipe recipe = (SolidifierRecipe)holder.value();
        return recipe.mold().test(this.itemHandler.getStackInSlot(0)) && this.hasEnoughFluid(recipe.fluid()) && this.hasCorrectInputAmount(recipe.mold()) && this.hasOutputSpaceMaking(this, recipe);
    }

    private void handleRecipeTick(SolidifierRecipe recipe) {
        FluidStack output = recipe.fluid();
        ++this.progress;
        if (this.progress >= this.maxProgress) {
            this.extractFluid(output, output.getAmount());
            if (!this.itemHandler.getStackInSlot(0).is(CastingTags.Items.MOLDS)) {
                this.itemHandler.getStackInSlot(0).shrink(recipe.mold().count());
            }
            ItemStack currentOutput = this.itemHandler.getStackInSlot(1);
            ItemStack result = new ItemStack((ItemLike)recipe.output().getItems()[0].getItem(), recipe.output().count());
            if (currentOutput.isEmpty()) {
                this.itemHandler.setStackInSlot(1, result);
            } else {
                currentOutput.grow(result.getCount());
            }
            this.setChanged();
            this.useFuel(this);
            this.resetProgress();
            this.sync();
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.casting.solidifier");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new SolidifierMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.put("tank", (Tag)this.TANK.writeToNBT(provider, new CompoundTag()));
        compoundTag.putInt("fuelTemp", this.fuelTemp);
        compoundTag.putInt("storedTankFluidAmount", this.storedTankFluidAmount);
        compoundTag.putInt("storedTankFluidAmountUsedInRecipe", this.storedTankFluidAmountUsedInRecipe);
        compoundTag.putBoolean("limitMode", this.isLimitMode);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.TANK.readFromNBT(provider, compoundTag.getCompound("tank"));
        this.fuelTemp = compoundTag.getInt("fuelTemp");
        this.storedTankFluidAmount = compoundTag.getInt("storedTankFluidAmount");
        this.storedTankFluidAmountUsedInRecipe = compoundTag.getInt("storedTankFluidAmountUsedInRecipe");
        this.isLimitMode = compoundTag.getBoolean("limitMode");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.sync();
        this.fuelInformation(this.level.getBlockEntity(this.worldPosition));
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            this.resetProgress();
            this.cachedRecipe = null;
            return;
        }
        RecipeInput inventory = new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return SolidifierBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return SolidifierBlockEntity.this.itemHandler.getSlots();
            }
        };
        if (this.cachedRecipe != null && this.isRecipeStillValid(this.cachedRecipe)) {
            this.handleRecipeTick((SolidifierRecipe)this.cachedRecipe.value());
            return;
        }
        for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)SolidifierRecipe.Type.INSTANCE, inventory, this.level)) {
            if (!this.isRecipeStillValid((RecipeHolder<SolidifierRecipe>)recipeHolder)) continue;
            this.cachedRecipe = recipeHolder;
            this.handleRecipeTick((SolidifierRecipe)recipeHolder.value());
            return;
        }
        this.resetProgress();
        this.cachedRecipe = null;
    }

    private boolean hasCorrectInputAmount(SizedIngredient mold) {
        return this.itemHandler.getStackInSlot(0).getCount() >= mold.count();
    }

    private void resetProgress() {
        this.progress = 0;
        this.sync();
    }

    private void extractFluid(FluidStack output, int amount) {
        if (this.TANK.getFluidAmount() >= amount && this.TANK.getFluid().getFluid() == output.getFluid()) {
            this.TANK.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean hasEnoughFluid(FluidStack output) {
        int tankAmount = this.TANK.getFluidAmount();
        if (this.isLimitMode) {
            tankAmount -= 100;
        }
        return tankAmount >= output.getAmount() && this.TANK.getFluid().getFluid() == output.getFluid();
    }

    private boolean isRecipeSlotsValidForTanks(SolidifierRecipe recipe) {
        FluidStack recipeFluid = recipe.fluid();
        return this.TANK.getFluid().is(recipeFluid.getFluidType()) && (this.tankIsValidForSlot(recipeFluid, 0) || this.tankIsValidForSlot(recipeFluid, 1));
    }

    private boolean tankIsValidForSlot(FluidStack stack, int slot) {
        return stack.getFluid() == this.TANK.getFluid().getFluid();
    }

    private boolean hasOutputSpaceMaking(SolidifierBlockEntity entity, SolidifierRecipe recipe) {
        ItemStack outputSlotStack = entity.itemHandler.getStackInSlot(1);
        SizedIngredient resultStack = recipe.output();
        if (outputSlotStack.isEmpty()) {
            return recipe.output().count() <= resultStack.getItems()[0].getItem().getDefaultMaxStackSize();
        }
        if (outputSlotStack.getItem() == resultStack.getItems()[0].getItem()) {
            return outputSlotStack.getCount() + recipe.output().count() <= outputSlotStack.getMaxStackSize();
        }
        return false;
    }

    private void fuelInformation(BlockEntity entity) {
        if (entity == null) {
            return;
        }
        Level level = entity.getLevel();
        if (level != null && !level.isClientSide()) {
            boolean foundFuel = false;
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)CoolantRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    CoolantRecipe recipe = (CoolantRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid() || tankBlockEntity.FLUID_TANK.getFluidAmount() < recipe.fluid().getAmount()) continue;
                    this.maxProgress = recipe.duration();
                    this.storedTankFluidAmount = tankBlockEntity.FLUID_TANK.getFluidAmount();
                    this.storedTankFluidAmountUsedInRecipe = recipe.fluid().getAmount();
                    foundFuel = true;
                    break;
                }
                if (foundFuel) break;
            }
            if (!foundFuel) {
                this.maxProgress = 220;
                this.fuelTemp = 1000;
            }
        }
    }

    private void useFuel(BlockEntity entity) {
        if (entity == null) {
            return;
        }
        Level level = entity.getLevel();
        if (level != null) {
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)CoolantRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    CoolantRecipe recipe = (CoolantRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid() || tankBlockEntity.FLUID_TANK.getFluidAmount() < recipe.fluid().getAmount()) continue;
                    tankBlockEntity.FLUID_TANK.drain(recipe.fluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    public boolean getLimitMode() {
        return this.isLimitMode;
    }

    public boolean toggleLimitMode() {
        this.isLimitMode = !this.isLimitMode;
        return this.isLimitMode;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        FluidStack fluid = this.TANK.getFluid();
        if (!fluid.isEmpty()) {
            builder.set(CastingDataComponents.FLUIDS, (Object)new FluidListComponent(List.of(fluid.copy())));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        FluidListComponent component = (FluidListComponent)input.get(CastingDataComponents.FLUIDS);
        if (component != null && !component.fluids().isEmpty()) {
            this.TANK.setFluid(component.fluids().get(0).copy());
        }
    }
}

