/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.util;

import org.jetbrains.annotations.NotNull;

public record GenericType(Class<?> type, GenericType[] genericTypes) {
    public static GenericType fromString(String typeString) {
        Class<?> type;
        String[] parts = typeString.split("<", 2);
        try {
            type = Class.forName(parts[0].trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + parts[0], e);
        }
        if (parts.length == 1) {
            return new GenericType(type, new GenericType[0]);
        }
        String genericPart = parts[1].replace(">", "").trim();
        String[] genericTypes = genericPart.split(",\\s*");
        GenericType[] genericTypeArray = new GenericType[genericTypes.length];
        for (int i = 0; i < genericTypes.length; ++i) {
            genericTypeArray[i] = GenericType.fromString(genericTypes[i]);
        }
        return new GenericType(type, genericTypeArray);
    }

    public boolean isRaw() {
        return this.genericTypes == null || this.genericTypes.length == 0;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.isRaw()) {
            return this.type.getCanonicalName();
        }
        StringBuilder sb = new StringBuilder(this.type.getCanonicalName());
        sb.append('<');
        for (int i = 0; i < this.genericTypes.length; ++i) {
            sb.append(this.genericTypes[i].toString());
            if (i >= this.genericTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append('>');
        return sb.toString();
    }
}

